/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.display;

import java.util.HashMap;
import java.util.HashSet;
import net.imglib2.converter.Converter;
import net.imglib2.display.ColorConverter;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.volatiles.VolatileARGBType;

public abstract class ARGBtoRandomARGBColorConverter<R>
implements ColorConverter,
Converter<R, ARGBType> {
    protected double min = 0.0;
    protected double max = 1.0;
    protected final ARGBType color = new ARGBType(ARGBType.rgba((int)0, (int)0, (int)0, (int)255));
    protected int A;
    protected double scaleR = 1.0;
    protected double scaleG = 1.0;
    protected double scaleB = 1.0;
    protected int black = 0;
    protected HashMap<Integer, Integer> map;
    protected HashSet<Integer> colorset;

    public ARGBtoRandomARGBColorConverter(double min, double max) {
        this.min = min;
        this.max = max;
        this.map = new HashMap();
        this.colorset = new HashSet();
        this.update();
    }

    public ARGBType getColor() {
        return this.color.copy();
    }

    public void setColor(ARGBType c) {
        this.color.set(c);
        this.update();
    }

    public boolean supportsColor() {
        return true;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
        this.update();
    }

    public void setMin(double min) {
        this.min = min;
        this.update();
    }

    private void update() {
        double scale = 1.0 / (this.max - this.min);
        int value = this.color.get();
        this.A = ARGBType.alpha((int)value);
        this.black = 0;
        this.map.clear();
        this.map.put(this.black, value);
        this.colorset.add(value);
    }

    int convertColor(int color) {
        int a = ARGBType.alpha((int)color);
        int r = ARGBType.red((int)color);
        int g = ARGBType.green((int)color);
        int b = ARGBType.blue((int)color);
        int v = r + 256 * g + 512 * b;
        int argb = -1;
        if (!this.map.containsKey(v)) {
            this.map.put(v, this.newColor());
        }
        if (argb >= 0) {
            return argb;
        }
        return this.map.get(v);
    }

    public int newColor() {
        int N = 1000;
        int argb = 0;
        for (int i = 0; i < N; ++i) {
            argb = ARGBType.rgba((int)((int)Math.min(255.0, 255.0 * Math.random())), (int)((int)Math.min(255.0, 255.0 * Math.random())), (int)((int)Math.min(255.0, 255.0 * Math.random())), (int)128);
            if (this.colorset.contains(argb)) continue;
            return argb;
        }
        return argb;
    }

    public static class VolatileToGray
    extends ARGBtoRandomARGBColorConverter<VolatileARGBType> {
        public VolatileToGray(double min, double max) {
            super(min, max);
        }

        public void convert(VolatileARGBType input, ARGBType output) {
            output.set(this.convertColor(((ARGBType)input.get()).get()));
        }
    }

    public static class ToGray
    extends ARGBtoRandomARGBColorConverter<ARGBType> {
        public ToGray(double min, double max) {
            super(min, max);
        }

        public void convert(ARGBType input, ARGBType output) {
            output.set(this.convertColor(input.get()));
        }
    }
}

