/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.Wrapped2DTransformAs3D;

public class InvertibleWrapped2DTransformAs3D
extends Wrapped2DTransformAs3D
implements InvertibleRealTransform {
    public InvertibleRealTransform transform;
    public double[] tmp;

    public InvertibleWrapped2DTransformAs3D(InvertibleRealTransform transform) {
        super((RealTransform)transform);
        this.transform = transform;
        this.tmp = new double[2];
    }

    public InvertibleRealTransform getTransform() {
        return this.transform;
    }

    public void applyInverse(double[] source, double[] target) {
        this.tmp[0] = target[0];
        this.tmp[1] = target[1];
        this.transform.applyInverse(this.tmp, this.tmp);
        source[0] = this.tmp[0];
        source[1] = this.tmp[1];
        source[2] = target[2];
    }

    public void applyInverse(RealPositionable source, RealLocalizable target) {
        this.tmp[0] = target.getDoublePosition(0);
        this.tmp[1] = target.getDoublePosition(1);
        this.transform.applyInverse(this.tmp, this.tmp);
        source.setPosition(this.tmp[0], 0);
        source.setPosition(this.tmp[1], 1);
        source.setPosition(target.getDoublePosition(2), 2);
    }

    @Override
    public InvertibleWrapped2DTransformAs3D copy() {
        return new InvertibleWrapped2DTransformAs3D(this.transform.copy());
    }

    public InvertibleRealTransform inverse() {
        return new InvertibleWrapped2DTransformAs3D(this.transform.inverse());
    }
}

