/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.RealTransform;

public class Wrapped2DTransformAs3D
implements RealTransform {
    public RealTransform transform;
    public double[] tmp;

    public Wrapped2DTransformAs3D(RealTransform transform) {
        this.transform = transform;
        this.tmp = new double[2];
    }

    public RealTransform getTransform() {
        return this.transform;
    }

    public int numSourceDimensions() {
        return 3;
    }

    public int numTargetDimensions() {
        return 3;
    }

    public void apply(double[] source, double[] target) {
        this.tmp[0] = source[0];
        this.tmp[1] = source[1];
        this.transform.apply(this.tmp, this.tmp);
        target[0] = this.tmp[0];
        target[1] = this.tmp[1];
        target[2] = source[2];
    }

    public void apply(RealLocalizable source, RealPositionable target) {
        this.tmp[0] = source.getDoublePosition(0);
        this.tmp[1] = source.getDoublePosition(1);
        this.transform.apply(this.tmp, this.tmp);
        target.setPosition(this.tmp[0], 0);
        target.setPosition(this.tmp[1], 1);
        target.setPosition(source.getDoublePosition(2), 2);
    }

    public Wrapped2DTransformAs3D copy() {
        return new Wrapped2DTransformAs3D(this.transform.copy());
    }
}

