/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.utility.geom;

import net.imglib2.RealPoint;
import org.janelia.utility.geom.GeomUtils;

public class Sphere {
    private RealPoint center;
    private double[] centerArr;
    private double radius;

    public Sphere(double[] center, double radius) {
        this.centerArr = center;
        this.radius = radius;
        this.center = RealPoint.wrap((double[])center);
    }

    public Sphere(RealPoint center, double radius) {
        this(center.positionAsDoubleArray(), radius);
    }

    public RealPoint getCenter() {
        return this.center;
    }

    public double[] getCenterArray() {
        return this.centerArr;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public void setCenter(double[] center) {
        System.arraycopy(center, 0, this.centerArr, 0, this.centerArr.length);
    }

    public boolean isInside(double[] p) {
        double r2 = this.radius * this.radius;
        return GeomUtils.squaredDistance(this.centerArr, p) <= r2;
    }
}

