/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.gpu.api;

import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Supplier;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import org.apache.commons.lang3.ArrayUtils;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuCopy;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuImage;
import sc.fiji.labkit.pixel_classification.gpu.api.Private;

public interface GpuApi
extends AutoCloseable {
    public GpuImage create(long[] var1, long var2, NativeTypeEnum var4);

    public GpuApi subScope();

    @Override
    public void close();

    default public GpuImage create(long[] dimensions, NativeTypeEnum type) {
        return this.create(dimensions, 1L, type);
    }

    default public GpuImage push(RandomAccessibleInterval<? extends RealType<?>> source) {
        GpuImage target = this.create(Intervals.dimensionsAsLongArray(source), GpuCopy.getNativeTypeEnum(source));
        return this.handleOutOfMemoryException(() -> {
            GpuCopy.copyFromTo(source, target);
            return target;
        });
    }

    default public GpuImage pushMultiChannel(RandomAccessibleInterval<? extends RealType<?>> input) {
        long[] dimensions = Intervals.dimensionsAsLongArray(input);
        int n = dimensions.length - 1;
        GpuImage buffer = this.create(Arrays.copyOf(dimensions, n), dimensions[n], NativeTypeEnum.Float);
        return this.handleOutOfMemoryException(() -> {
            GpuCopy.copyFromTo(input, buffer);
            return buffer;
        });
    }

    default public <T extends RealType<?>> RandomAccessibleInterval<T> pullRAI(GpuImage image) {
        return this.handleOutOfMemoryException(() -> {
            if (image.getNumberOfChannels() > 1L) {
                return this.pullRAIMultiChannel(image);
            }
            return Private.internalPullRai(image, image.getDimensions());
        });
    }

    default public <T extends RealType<?>> RandomAccessibleInterval<T> pullRAIMultiChannel(GpuImage image) {
        return this.handleOutOfMemoryException(() -> {
            long[] dimensions = ArrayUtils.add((long[])image.getDimensions(), (long)image.getNumberOfChannels());
            return Private.internalPullRai(image, dimensions);
        });
    }

    public void execute(Class<?> var1, String var2, String var3, long[] var4, long[] var5, HashMap<String, Object> var6, HashMap<String, Object> var7);

    public <T> T handleOutOfMemoryException(Supplier<T> var1);
}

