/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.gpu.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import net.imglib2.Dimensions;
import net.imglib2.util.Intervals;
import net.imglib2.util.ValuePair;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuApi;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuImage;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuView;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuViews;
import sc.fiji.labkit.pixel_classification.gpu.api.OpenCLSyntax;

public class GpuPixelWiseOperation {
    private List<String> COORDINATE_VARIABLE_NAMES = Arrays.asList("coordinate_x", "coordinate_y", "coordinate_z");
    private final GpuApi gpu;
    private final List<String> parameterDefinition = new ArrayList<String>();
    private final List<String> preOperation = new ArrayList<String>();
    private final List<String> postOperation = new ArrayList<String>();
    private final HashMap<String, Object> parameterValues = new HashMap();
    private final Map<GpuImage, String> images = new HashMap<GpuImage, String>();
    private final List<ValuePair<String, long[]>> imageSizes = new ArrayList<ValuePair<String, long[]>>();

    private GpuPixelWiseOperation(GpuApi gpu) {
        this.gpu = gpu;
    }

    public static GpuPixelWiseOperation gpu(GpuApi gpu) {
        return new GpuPixelWiseOperation(gpu);
    }

    public GpuPixelWiseOperation addInput(String variable, int image) {
        this.addParameter("int", variable, image);
        return this;
    }

    public GpuPixelWiseOperation addInput(String variable, long image) {
        this.addParameter("long", variable, image);
        return this;
    }

    public GpuPixelWiseOperation addInput(String variable, float image) {
        this.addParameter("float", variable, Float.valueOf(image));
        return this;
    }

    public GpuPixelWiseOperation addInput(String variable, double image) {
        this.addParameter("double", variable, image);
        return this;
    }

    public GpuPixelWiseOperation addInput(String variable, GpuImage image) {
        return this.addInput(variable, GpuViews.wrap(image));
    }

    public GpuPixelWiseOperation addOutput(String variable, GpuImage image) {
        return this.addOutput(variable, GpuViews.wrap(image));
    }

    public GpuPixelWiseOperation addInput(String variable, GpuView image) {
        String parameterName = this.addGpuViewParameter(variable, image);
        this.preOperation.add("IMAGE_" + parameterName + "_PIXEL_TYPE " + variable + " = " + this.pixelAt(parameterName, image.offset()));
        return this;
    }

    public GpuPixelWiseOperation addOutput(String variable, GpuView image) {
        String parameterName = this.addGpuViewParameter(variable, image);
        this.preOperation.add("IMAGE_" + parameterName + "_PIXEL_TYPE " + variable + " = 0");
        this.postOperation.add(this.pixelAt(parameterName, image.offset()) + " = " + variable);
        return this;
    }

    private String pixelAt(String parameterName, long offset) {
        return "PIXEL_OFFSET(" + parameterName + ", " + offset + ")";
    }

    private String addGpuViewParameter(String variable, GpuView image) {
        this.checkValidVariableName(variable);
        String parameterName = this.addImageParameter(image.source());
        this.registerSize(variable, Intervals.dimensionsAsLongArray((Dimensions)image.dimensions()));
        return parameterName;
    }

    private void registerSize(String variable, long[] size) {
        this.imageSizes.add((ValuePair<String, long[]>)new ValuePair((Object)variable, (Object)size));
    }

    private String addImageParameter(GpuImage image) {
        if (this.images.containsKey(image)) {
            return this.images.get(image);
        }
        String parameterName = "image_" + (this.images.size() + 1);
        this.images.put(image, parameterName);
        this.addParameter("IMAGE_" + parameterName + "_TYPE ", parameterName, image);
        return parameterName;
    }

    private void addParameter(String parameterType, String parameterName, Object value) {
        this.checkValidVariableName(parameterName);
        this.parameterDefinition.add(parameterType + " " + parameterName);
        this.parameterValues.put(parameterName, value);
    }

    private void checkValidVariableName(String variable) {
        if (this.COORDINATE_VARIABLE_NAMES.contains(variable) || !OpenCLSyntax.isValidVariableName(variable)) {
            throw new IllegalArgumentException("Sorry \"" + variable + "\" can not be used as a variable name.");
        }
    }

    public void forEachPixel(String operation) {
        long[] dims = this.checkDimensions();
        HashMap<String, Object> defines = new HashMap<String, Object>();
        defines.put("PARAMETER", GpuPixelWiseOperation.concatenate(", ", this.parameterDefinition));
        defines.put("OPERATION", GpuPixelWiseOperation.concatenate("; ", this.preOperation, Collections.singletonList(operation), this.postOperation));
        this.gpu.execute(GpuPixelWiseOperation.class, "pixelwise_operation.cl", "operation", dims, null, this.parameterValues, defines);
    }

    @SafeVarargs
    private static String concatenate(String delimiter, List<String> ... lists) {
        StringJoiner joiner = new StringJoiner(delimiter);
        for (List<String> values : lists) {
            values.forEach(joiner::add);
        }
        return joiner.toString();
    }

    private long[] checkDimensions() {
        long[] dims = (long[])this.imageSizes.get(0).getB();
        for (ValuePair<String, long[]> image : this.imageSizes) {
            if (Arrays.equals(dims, (long[])image.getB())) continue;
            this.wrongDimensionsError();
        }
        return dims;
    }

    private void wrongDimensionsError() {
        StringJoiner joiner = new StringJoiner(" ");
        for (ValuePair<String, long[]> pair : this.imageSizes) {
            String imageName = (String)pair.getA();
            long[] imageSize = (long[])pair.getB();
            joiner.add("size(" + imageName + ")=" + Arrays.toString(imageSize));
        }
        throw new IllegalArgumentException("Error the sizes of the input images don't match: " + joiner);
    }
}

