/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.gpu.api;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.util.IntervalIndexer;
import net.imglib2.util.Intervals;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuApi;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuCopy;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuImage;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuView;

public class GpuViews {
    public static GpuView wrap(GpuImage buffer) {
        return new GpuView(buffer, (Dimensions)new FinalDimensions(buffer.getDimensions()), 0L);
    }

    public static GpuView crop(GpuImage image, Interval interval) {
        long[] dimensions = image.getDimensions();
        long offset = IntervalIndexer.positionToIndex((long[])Intervals.minAsLongArray((Interval)interval), (long[])dimensions);
        return new GpuView(image, (Dimensions)new FinalDimensions((Dimensions)interval), offset);
    }

    public static GpuView crop(GpuView image, Interval interval) {
        GpuImage source = image.source();
        long[] dimensions = source.getDimensions();
        long offset = IntervalIndexer.positionToIndex((long[])Intervals.minAsLongArray((Interval)interval), (long[])dimensions);
        return new GpuView(source, (Dimensions)new FinalDimensions((Dimensions)interval), offset + image.offset());
    }

    public static GpuView shrink(GpuImage image, long[] border) {
        long[] negativeBorder = LongStream.of(border).map(x -> -x).toArray();
        return GpuViews.crop(image, (Interval)Intervals.expand((Interval)new FinalInterval(image.getDimensions()), (long[])negativeBorder));
    }

    public static GpuView channel(GpuImage image, long position) {
        if (position < 0L || position >= image.getNumberOfChannels()) {
            throw new IllegalArgumentException();
        }
        return new GpuView(image, (Dimensions)new FinalDimensions(image.getDimensions()), Intervals.numElements((long[])image.getDimensions()) * position);
    }

    public static GpuImage asGpuImage(GpuApi gpu, GpuView view) {
        GpuImage buffer = gpu.create(Intervals.dimensionsAsLongArray((Dimensions)view.dimensions()), NativeTypeEnum.Float);
        GpuCopy.copyFromTo(gpu, view, GpuViews.wrap(buffer));
        return buffer;
    }

    public static List<GpuView> channels(GpuImage buffer) {
        return LongStream.range(0L, buffer.getNumberOfChannels()).mapToObj(i -> GpuViews.channel(buffer, i)).collect(Collectors.toList());
    }
}

