/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import sc.fiji.labkit.pixel_classification.gui.IconResources;

public abstract class AccordionSection
extends JPanel {
    private static final ImageIcon EXPANDED_ICON = IconResources.getIcon("arrow_down_48px.png");
    private static final ImageIcon COLLAPSED_ICON = IconResources.getIcon("arrow_right_48px.png");
    private static final int MIN_COMPONENT_WIDTH = 200;
    private static final int PREFERRED_COMPONENT_WIDTH = 500;
    private final JButton iconButton;
    private boolean expanded = true;

    public AccordionSection(boolean isExpanded) {
        this.expanded = isExpanded;
        this.iconButton = this.createArrowButten();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(200, this.currentHeight());
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(500, this.currentHeight());
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, this.currentHeight());
    }

    private int currentHeight() {
        return this.expanded ? this.preferredExpandedHeight() : this.preferredCollapsedHeight();
    }

    protected JButton getIconButton() {
        return this.iconButton;
    }

    protected abstract int preferredCollapsedHeight();

    protected abstract int preferredExpandedHeight();

    private JButton createArrowButten() {
        JButton iconButton = new JButton(this.currentIcon());
        iconButton.setFocusPainted(false);
        iconButton.setMargin(new Insets(0, 0, 0, 0));
        iconButton.setContentAreaFilled(false);
        iconButton.setBorderPainted(false);
        iconButton.setOpaque(false);
        iconButton.addActionListener(this::toggle);
        this.add((Component)iconButton, "Center");
        return iconButton;
    }

    private void toggle(ActionEvent e) {
        this.expanded = !this.expanded;
        this.iconButton.setIcon(this.currentIcon());
        this.revalidate();
        this.repaint();
    }

    private ImageIcon currentIcon() {
        return this.expanded ? EXPANDED_ICON : COLLAPSED_ICON;
    }
}

