/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.pixel_feature.filter;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.DoubleStream;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.convolution.Convolution;
import net.imglib2.algorithm.convolution.kernel.Kernel1D;
import net.imglib2.algorithm.convolution.kernel.SeparableKernelConvolution;
import net.imglib2.algorithm.gauss3.Gauss3;
import net.imglib2.converter.RealTypeConverters;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;

public class FeatureInput {
    private final RandomAccessible<FloatType> original;
    private final Interval target;
    private final Map<Double, RandomAccessibleInterval<DoubleType>> gaussCache = new ConcurrentHashMap<Double, RandomAccessibleInterval<DoubleType>>();
    private final Map<Object, RandomAccessibleInterval<DoubleType>> derivatives = new ConcurrentHashMap<Object, RandomAccessibleInterval<DoubleType>>();
    private double[] pixelSize;
    static List<Kernel1D> SIMPLE_KERNELS = Arrays.asList(Kernel1D.centralAsymmetric((double[])new double[]{1.0}), Kernel1D.centralAsymmetric((double[])new double[]{0.5, 0.0, -0.5}), Kernel1D.centralAsymmetric((double[])new double[]{1.0, -2.0, 1.0}));

    public FeatureInput(RandomAccessible<FloatType> original, Interval targetInterval, double[] pixelSize) {
        this.original = original;
        this.pixelSize = pixelSize;
        this.target = new FinalInterval(targetInterval);
    }

    public void setPixelSize(double ... pixelSize) {
        this.pixelSize = pixelSize;
    }

    public RandomAccessible<FloatType> original() {
        return this.original;
    }

    public Interval targetInterval() {
        return this.target;
    }

    public RandomAccessibleInterval<DoubleType> gauss(double sigma) {
        return Views.interval(this.extendedGauss(sigma), (Interval)this.target);
    }

    private RandomAccessibleInterval<DoubleType> extendedGauss(double sigma) {
        return this.gaussCache.computeIfAbsent(sigma, this::calculateGauss);
    }

    private RandomAccessibleInterval<DoubleType> calculateGauss(double sigma) {
        RandomAccessibleInterval<DoubleType> result = this.create((Interval)Intervals.expand((Interval)this.target, (long)2L));
        if (sigma == 0.0) {
            RealTypeConverters.copyFromTo(this.original, result);
        } else {
            Gauss3.gauss((double[])this.scaledSigmas(sigma), this.original, result);
        }
        return result;
    }

    private double[] scaledSigmas(double sigma) {
        return DoubleStream.of(this.pixelSize).map(p -> sigma / p).toArray();
    }

    public RandomAccessibleInterval<DoubleType> derivedGauss(double sigma, int ... order) {
        return this.derivatives.computeIfAbsent(FeatureInput.key(sigma, order), k -> this.calculateDerivative(sigma, order));
    }

    private static Object key(double sigma, int ... order) {
        return Arrays.asList(sigma, new TIntArrayList(order));
    }

    private RandomAccessibleInterval<DoubleType> calculateDerivative(double sigma, int[] orders) {
        ArrayList<Convolution> convolutions = new ArrayList<Convolution>();
        for (int i = 0; i < orders.length; ++i) {
            int order = orders[i];
            if (order == 0) continue;
            Kernel1D multiply = this.multiply(SIMPLE_KERNELS.get(order), Math.pow(this.pixelSize[i], -order));
            convolutions.add(SeparableKernelConvolution.convolution1d((Kernel1D)multiply, (int)i));
        }
        if (convolutions.isEmpty()) {
            return this.gauss(sigma);
        }
        RandomAccessibleInterval<DoubleType> result = this.create(this.target);
        Convolution.concat(convolutions).process(this.extendedGauss(sigma), result);
        return result;
    }

    private Kernel1D multiply(Kernel1D kernel1D, double scaleFactor) {
        double[] fullKernel = this.multiply(kernel1D.fullKernel(), scaleFactor);
        int originIndex = (int)(-kernel1D.min());
        return Kernel1D.asymmetric((double[])fullKernel, (int)originIndex);
    }

    private double[] multiply(double[] array, double scaleFactor) {
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] * scaleFactor;
        }
        return result;
    }

    private RandomAccessibleInterval<DoubleType> create(Interval target) {
        return Views.translate((RandomAccessibleInterval)ArrayImgs.doubles((long[])Intervals.dimensionsAsLongArray((Dimensions)target)), (long[])Intervals.minAsLongArray((Interval)target));
    }
}

