/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.pixel_feature.filter.deprecated.lipschitz;

import java.util.function.BiConsumer;
import java.util.stream.LongStream;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Localizables;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import sc.fiji.labkit.pixel_classification.RevampUtils;

class ConeMorphology {
    ConeMorphology() {
    }

    static <T extends RealType<T>> void performConeOperation(Operation operation, RandomAccessibleInterval<T> inOut, double[] slope) {
        for (Localizable location : ConeMorphology.neighborhood(inOut.numDimensions())) {
            ConeMorphology.oneRun(slope, Localizables.asLongArray((Localizable)location), inOut, operation);
        }
    }

    private static Iterable<Localizable> neighborhood(int n) {
        RectangleShape shape = new RectangleShape(1, true);
        RandomAccess ra = shape.neighborhoodsRandomAccessible(Localizables.randomAccessible((int)n)).randomAccess();
        ra.setPosition(RevampUtils.nCopies(ra.numDimensions(), 0L));
        return (Iterable)ra.get();
    }

    private static <T extends RealType<T>> void oneRun(double[] slope, long[] translation, RandomAccessibleInterval<T> image, Operation operation) {
        double combinedSlope = ConeMorphology.calculateCombinedSlope(slope, translation);
        IntervalView<T> centers = ConeMorphology.cutBorders(translation, image);
        IntervalView<T> neighbors = ConeMorphology.cutBorders(ConeMorphology.negate(translation), image);
        LoopBuilder.setImages(ConeMorphology.invertDirections(centers, translation), ConeMorphology.invertDirections(neighbors, translation)).flatIterationOrder().forEachPixel(ConeMorphology.getAction(operation, combinedSlope));
    }

    private static <T extends RealType<T>> IntervalView<T> cutBorders(long[] translation, RandomAccessibleInterval<T> image) {
        return Views.interval(image, (Interval)Intervals.intersect(image, (Interval)Intervals.translate(image, (long[])translation)));
    }

    private static long[] negate(long[] values) {
        return LongStream.of(values).map(x -> -x).toArray();
    }

    private static <T extends RealType<T>> BiConsumer<T, T> getAction(Operation operation, double combinedSlope) {
        switch (operation) {
            case DILATION: {
                return (center, neighbor) -> center.setReal(Math.max(center.getRealDouble(), neighbor.getRealDouble() - combinedSlope));
            }
            case EROSION: {
                return (center, neighbor) -> center.setReal(Math.min(center.getRealDouble(), neighbor.getRealDouble() + combinedSlope));
            }
        }
        throw new AssertionError();
    }

    private static <T> RandomAccessibleInterval<T> invertDirections(RandomAccessibleInterval<T> pair, long[] translation) {
        for (int i = pair.numDimensions() - 1; i >= 0; --i) {
            if (translation[i] >= 0L) continue;
            return Views.invertAxis(pair, (int)i);
        }
        return pair;
    }

    private static double calculateCombinedSlope(double[] slope, long[] translation) {
        double combinedSlope = 0.0;
        for (int i = 0; i < slope.length; ++i) {
            combinedSlope += Math.pow((double)translation[i] * slope[i], 2.0);
        }
        combinedSlope = Math.sqrt(combinedSlope);
        return combinedSlope;
    }

    static enum Operation {
        DILATION,
        EROSION;

    }
}

