/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.pixel_feature.filter.hessian;

import java.util.List;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.linalg.eigen.EigenValues;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;
import net.imglib2.view.composite.Composite;
import sc.fiji.labkit.pixel_classification.utils.CubicEquation;

public class EigenValuesSymmetric3D<T extends RealType<T>, C extends RealType<C>>
implements EigenValues<T, C> {
    private final double[] x = new double[3];

    public static void calc(RandomAccessibleInterval<DoubleType> a11, RandomAccessibleInterval<DoubleType> a12, RandomAccessibleInterval<DoubleType> a13, RandomAccessibleInterval<DoubleType> a22, RandomAccessibleInterval<DoubleType> a23, RandomAccessibleInterval<DoubleType> a33, List<RandomAccessibleInterval<FloatType>> output) {
        Cursor c11 = Views.flatIterable(a11).cursor();
        Cursor c12 = Views.flatIterable(a12).cursor();
        Cursor c13 = Views.flatIterable(a13).cursor();
        Cursor c22 = Views.flatIterable(a22).cursor();
        Cursor c23 = Views.flatIterable(a23).cursor();
        Cursor c33 = Views.flatIterable(a33).cursor();
        Cursor o0 = Views.flatIterable(output.get(0)).cursor();
        Cursor o1 = Views.flatIterable(output.get(1)).cursor();
        Cursor o2 = Views.flatIterable(output.get(2)).cursor();
        double[] e = new double[3];
        while (o1.hasNext()) {
            double v11 = ((DoubleType)c11.next()).getRealDouble();
            double v12 = ((DoubleType)c12.next()).getRealDouble();
            double v13 = ((DoubleType)c13.next()).getRealDouble();
            double v22 = ((DoubleType)c22.next()).getRealDouble();
            double v23 = ((DoubleType)c23.next()).getRealDouble();
            double v33 = ((DoubleType)c33.next()).getRealDouble();
            EigenValuesSymmetric3D.calc(v11, v12, v13, v22, v23, v33, e);
            ((FloatType)o0.next()).setReal(e[2]);
            ((FloatType)o1.next()).setReal(e[1]);
            ((FloatType)o2.next()).setReal(e[0]);
        }
    }

    public void compute(Composite<T> matrix, Composite<C> evs) {
        this.eigenvalues(matrix);
        this.copyTo(evs);
    }

    public void computeMagnitudeOfEigenvalues(Composite<T> matrix, Composite<C> evs) {
        this.eigenvalues(matrix);
        this.abs();
        this.sort();
        this.copyTo(evs);
    }

    private void eigenvalues(Composite<T> matrix) {
        double a11 = ((RealType)matrix.get(0L)).getRealDouble();
        double a12 = ((RealType)matrix.get(1L)).getRealDouble();
        double a13 = ((RealType)matrix.get(2L)).getRealDouble();
        double a22 = ((RealType)matrix.get(3L)).getRealDouble();
        double a23 = ((RealType)matrix.get(4L)).getRealDouble();
        double a33 = ((RealType)matrix.get(5L)).getRealDouble();
        EigenValuesSymmetric3D.calc(a11, a12, a13, a22, a23, a33, this.x);
    }

    private static void calc(double a11, double a12, double a13, double a22, double a23, double a33, double[] x) {
        double b2 = -(a11 + a22 + a33);
        double b1 = a11 * a22 + a11 * a33 + a22 * a33 - a12 * a12 - a13 * a13 - a23 * a23;
        double b0 = a11 * (a23 * a23 - a22 * a33) + a22 * a13 * a13 + a33 * a12 * a12 - 2.0 * a12 * a13 * a23;
        CubicEquation.solveNormalized(b0, b1, b2, x);
    }

    private void abs() {
        this.x[0] = Math.abs(this.x[0]);
        this.x[1] = Math.abs(this.x[1]);
        this.x[2] = Math.abs(this.x[2]);
    }

    private void sort() {
        this.order(this.x, 0, 1);
        this.order(this.x, 1, 2);
        this.order(this.x, 0, 1);
    }

    private void order(double[] x, int smaller, int larger) {
        if (x[smaller] > x[larger]) {
            double tmp = x[smaller];
            x[smaller] = x[larger];
            x[larger] = tmp;
        }
    }

    private void copyTo(Composite<C> evs) {
        ((RealType)evs.get(0L)).setReal(this.x[2]);
        ((RealType)evs.get(1L)).setReal(this.x[1]);
        ((RealType)evs.get(2L)).setReal(this.x[0]);
    }

    public EigenValues<T, C> copy() {
        return new EigenValuesSymmetric3D<T, C>();
    }
}

