/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.pixel_feature.settings;

import com.google.gson.annotations.JsonAdapter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.ChannelSettingJsonAdapter;

@JsonAdapter(value=ChannelSettingJsonAdapter.class)
public class ChannelSetting {
    public static final ChannelSetting DEPRECATED_RGB = new ChannelSetting("RGB", false, "red", "green", "blue");
    public static final ChannelSetting RGB = new ChannelSetting("RGB8", false, "red", "green", "blue");
    public static final ChannelSetting SINGLE = new ChannelSetting("SINGLE", false, "");
    private final List<String> channels;
    private final String toString;
    private final boolean isMultiple;

    public static ChannelSetting multiple(int n) {
        return new ChannelSetting("MULTIPLE_" + n, true, (String[])IntStream.range(0, n).mapToObj(i -> "channel" + (i + 1)).toArray(String[]::new));
    }

    private ChannelSetting(String toString, boolean isMultiple, String ... names) {
        this.channels = Collections.unmodifiableList(Arrays.asList(names));
        this.toString = toString;
        this.isMultiple = isMultiple;
    }

    public List<String> channels() {
        return this.channels;
    }

    public boolean isMultiple() {
        return this.isMultiple;
    }

    public static ChannelSetting valueOf(String value) {
        if (value.equals(DEPRECATED_RGB.toString())) {
            return DEPRECATED_RGB;
        }
        if (value.equals(RGB.toString())) {
            return RGB;
        }
        if (value.equals(SINGLE.toString())) {
            return SINGLE;
        }
        if (value.startsWith("MULTIPLE_")) {
            String number = value.substring("MULTIPLE_".length());
            try {
                return ChannelSetting.multiple(Integer.valueOf(number));
            }
            catch (NumberFormatException ignore) {
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return this.toString;
    }

    public boolean equals(Object o) {
        return o instanceof ChannelSetting && this.toString.equals(o.toString());
    }
}

