/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.utils.views;

import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.loops.ClassCopyProvider;
import net.imglib2.util.Cast;
import net.imglib2.view.composite.Composite;

public class CompositeRandomAccess<T>
implements RandomAccess<Composite<T>>,
Composite<T> {
    private static final ClassCopyProvider<RandomAccess> provide = new ClassCopyProvider(CompositeRandomAccess.class, RandomAccess.class, new Class[0]);
    private final RandomAccess<T> ra;
    private final int n;

    public static <T> RandomAccess<Composite<T>> create(RandomAccess<T> ra) {
        return (RandomAccess)Cast.unchecked((Object)provide.newInstanceForKey(ra.getClass(), new Object[]{ra}));
    }

    public CompositeRandomAccess(RandomAccess<T> ra) {
        this.ra = ra;
        this.n = ra.numDimensions() - 1;
    }

    public RandomAccess<Composite<T>> copy() {
        return new CompositeRandomAccess<T>(this.ra.copy());
    }

    public Composite<T> get() {
        return this;
    }

    public T get(long i) {
        this.ra.setPosition(i, this.n);
        return (T)this.ra.get();
    }

    public long getLongPosition(int d) {
        return this.ra.getLongPosition(d);
    }

    public void fwd(int d) {
        this.ra.fwd(d);
    }

    public void bck(int d) {
        this.ra.bck(d);
    }

    public void move(int distance, int d) {
        this.ra.move(distance, d);
    }

    public void move(long distance, int d) {
        this.ra.move(distance, d);
    }

    public void move(Localizable distance) {
        for (int d = 0; d < this.n; ++d) {
            this.move(distance.getLongPosition(d), d);
        }
    }

    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            this.move(distance[d], d);
        }
    }

    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            this.move(distance[d], d);
        }
    }

    public void setPosition(Localizable position) {
        for (int d = 0; d < this.n; ++d) {
            this.setPosition(position.getLongPosition(d), d);
        }
    }

    public void setPosition(int[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.setPosition(position[d], d);
        }
    }

    public void setPosition(long[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.setPosition(position[d], d);
        }
    }

    public void setPosition(int position, int d) {
        this.ra.setPosition(position, d);
    }

    public void setPosition(long position, int d) {
        this.ra.setPosition(position, d);
    }

    public int numDimensions() {
        return this.n;
    }
}

