/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.links;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Links {
    private Links() {
    }

    public static String path(URI uri) {
        String path = uri.getPath();
        if (path == null) {
            return null;
        }
        return path.startsWith("/") ? path.substring(1) : path;
    }

    public static String operation(URI uri) {
        String path = Links.path(uri);
        if (path == null) {
            return null;
        }
        int slash = path.indexOf("/");
        return slash < 0 ? path : path.substring(0, slash);
    }

    public static String[] pathFragments(URI uri) {
        String path = Links.path(uri);
        if (path == null) {
            return null;
        }
        return path.isEmpty() ? new String[]{} : path.split("/");
    }

    public static String subPath(URI uri) {
        String path = Links.path(uri);
        if (path == null) {
            return null;
        }
        int slash = path.indexOf("/");
        return slash < 0 ? "" : path.substring(slash + 1);
    }

    public static Map<String, String> query(URI uri) {
        String[] tokens;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String query = uri.getQuery();
        for (String token : tokens = query == null ? new String[]{} : query.split("&")) {
            String[] kv = token.split("=", 2);
            String k = kv[0];
            String v = kv.length > 1 ? kv[1] : null;
            map.put(k, v);
        }
        return map;
    }
}

