/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.geometry;

import org.scijava.java3d.utils.geometry.Triangulator;

class BBox {
    int imin;
    int imax;
    double ymin;
    double ymax;

    BBox(Triangulator triRef, int i, int j) {
        this.imin = Math.min(i, j);
        this.imax = Math.max(i, j);
        this.ymin = Math.min(triRef.points[this.imin].y, triRef.points[this.imax].y);
        this.ymax = Math.max(triRef.points[this.imin].y, triRef.points[this.imax].y);
    }

    boolean pntInBBox(Triangulator triRef, int i) {
        return this.imax < i ? false : (this.imin > i ? false : (this.ymax < (double)triRef.points[i].y ? false : !(this.ymin > (double)triRef.points[i].y)));
    }

    boolean BBoxOverlap(BBox bb) {
        return this.imax < bb.imin ? false : (this.imin > bb.imax ? false : (this.ymax < bb.ymin ? false : !(this.ymin > bb.ymax)));
    }

    boolean BBoxContained(BBox bb) {
        return this.imin <= bb.imin && this.imax >= bb.imax && this.ymin <= bb.ymin && this.ymax >= bb.ymax;
    }

    boolean BBoxIdenticalLeaf(BBox bb) {
        return this.imin == bb.imin && this.imax == bb.imax;
    }

    void BBoxUnion(BBox bb1, BBox bb3) {
        bb3.imin = Math.min(this.imin, bb1.imin);
        bb3.imax = Math.max(this.imax, bb1.imax);
        bb3.ymin = Math.min(this.ymin, bb1.ymin);
        bb3.ymax = Math.max(this.ymax, bb1.ymax);
    }

    double BBoxArea(Triangulator triRef) {
        return (double)(triRef.points[this.imax].x - triRef.points[this.imin].x) * (this.ymax - this.ymin);
    }
}

