/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.scijava.java3d.BoundingLeaf;
import org.scijava.java3d.Clip;
import org.scijava.java3d.utils.scenegraph.io.retained.Controller;
import org.scijava.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.LeafState;

public abstract class ClipState
extends LeafState {
    private int boundingLeaf;

    public ClipState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null) {
            this.boundingLeaf = control.getSymbolTable().addReference(((Clip)this.node).getApplicationBoundingLeaf());
        }
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        out.writeInt(this.boundingLeaf);
        this.control.writeBounds(out, ((Clip)this.node).getApplicationBounds());
        out.writeDouble(((Clip)this.node).getBackDistance());
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        this.boundingLeaf = in.readInt();
        ((Clip)this.node).setApplicationBounds(this.control.readBounds(in));
        ((Clip)this.node).setBackDistance(in.readDouble());
    }

    @Override
    public void buildGraph() {
        ((Clip)this.node).setApplicationBoundingLeaf((BoundingLeaf)this.control.getSymbolTable().getJ3dNode(this.boundingLeaf));
        super.buildGraph();
    }
}

