/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.scijava.java3d.PointLight;
import org.scijava.java3d.SceneGraphObject;
import org.scijava.java3d.SpotLight;
import org.scijava.java3d.utils.scenegraph.io.retained.Controller;
import org.scijava.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.LightState;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.Vector3f;

public class SpotLightState
extends LightState {
    public SpotLightState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        Point3f point = new Point3f();
        ((PointLight)this.node).getAttenuation(point);
        this.control.writePoint3f(out, point);
        ((PointLight)this.node).getPosition(point);
        this.control.writePoint3f(out, point);
        Vector3f dir = new Vector3f();
        ((SpotLight)this.node).getDirection(dir);
        this.control.writeVector3f(out, dir);
        out.writeFloat(((SpotLight)this.node).getSpreadAngle());
        out.writeFloat(((SpotLight)this.node).getConcentration());
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        if (this.control.getCurrentFileVersion() >= 5) {
            ((PointLight)this.node).setAttenuation(this.control.readPoint3f(in));
            ((PointLight)this.node).setPosition(this.control.readPoint3f(in));
        }
        ((SpotLight)this.node).setDirection(this.control.readVector3f(in));
        ((SpotLight)this.node).setSpreadAngle(in.readFloat());
        ((SpotLight)this.node).setConcentration(in.readFloat());
    }

    @Override
    protected SceneGraphObject createNode() {
        return new SpotLight();
    }
}

