/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.utils.geometry;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.scijava.java3d.Appearance;
import org.scijava.java3d.SceneGraphObject;
import org.scijava.java3d.utils.geometry.Cylinder;
import org.scijava.java3d.utils.scenegraph.io.retained.Controller;
import org.scijava.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.utils.geometry.PrimitiveState;

public class CylinderState
extends PrimitiveState {
    private float radius = 1.0f;
    private float height = 2.0f;
    private int xdivision = 15;
    private int ydivision = 1;
    private int topAppearance;
    private int bottomAppearance;
    private int bodyAppearance;

    public CylinderState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null) {
            this.bodyAppearance = control.getSymbolTable().addReference(((Cylinder)this.node).getShape(0).getAppearance());
            this.topAppearance = control.getSymbolTable().addReference(((Cylinder)this.node).getShape(1).getAppearance());
            this.bottomAppearance = control.getSymbolTable().addReference(((Cylinder)this.node).getShape(2).getAppearance());
        }
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        out.writeInt(this.topAppearance);
        out.writeInt(this.bodyAppearance);
        out.writeInt(this.bottomAppearance);
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        this.topAppearance = in.readInt();
        this.bodyAppearance = in.readInt();
        this.bottomAppearance = in.readInt();
    }

    @Override
    public void writeConstructorParams(DataOutput out) throws IOException {
        super.writeConstructorParams(out);
        out.writeFloat(((Cylinder)this.node).getRadius());
        out.writeFloat(((Cylinder)this.node).getHeight());
        out.writeInt(((Cylinder)this.node).getXdivisions());
        out.writeInt(((Cylinder)this.node).getYdivisions());
    }

    @Override
    public void readConstructorParams(DataInput in) throws IOException {
        super.readConstructorParams(in);
        this.radius = in.readFloat();
        this.height = in.readFloat();
        this.xdivision = in.readInt();
        this.ydivision = in.readInt();
    }

    @Override
    public void buildGraph() {
        if (this.bodyAppearance == this.topAppearance && this.bodyAppearance == this.bottomAppearance) {
            ((Cylinder)this.node).setAppearance((Appearance)this.control.getSymbolTable().getJ3dNode(this.bodyAppearance));
        } else {
            ((Cylinder)this.node).setAppearance(0, (Appearance)this.control.getSymbolTable().getJ3dNode(this.bodyAppearance));
            ((Cylinder)this.node).setAppearance(1, (Appearance)this.control.getSymbolTable().getJ3dNode(this.topAppearance));
            ((Cylinder)this.node).setAppearance(2, (Appearance)this.control.getSymbolTable().getJ3dNode(this.bottomAppearance));
        }
        super.buildGraph();
    }

    @Override
    public SceneGraphObject createNode(Class j3dClass) {
        Cylinder cylinder = (Cylinder)this.createNode(j3dClass, new Class[]{Float.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Appearance.class}, new Object[]{new Float(this.radius), new Float(this.height), new Integer(this.primflags), new Integer(this.xdivision), new Integer(this.ydivision), null});
        return cylinder;
    }

    @Override
    protected SceneGraphObject createNode() {
        return new Cylinder(this.radius, this.height, this.primflags, this.xdivision, this.ydivision, null);
    }
}

