/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.platforms.macos;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.AppEventListener;
import com.apple.eawt.AppForegroundListener;
import com.apple.eawt.AppHiddenListener;
import com.apple.eawt.AppReOpenedListener;
import com.apple.eawt.Application;
import com.apple.eawt.OpenFilesHandler;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.PrintFilesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import com.apple.eawt.ScreenSleepListener;
import com.apple.eawt.SystemSleepListener;
import com.apple.eawt.UserSessionListener;
import org.scijava.event.EventService;
import org.scijava.event.SciJavaEvent;
import org.scijava.platform.event.AppAboutEvent;
import org.scijava.platform.event.AppFocusEvent;
import org.scijava.platform.event.AppOpenFilesEvent;
import org.scijava.platform.event.AppPreferencesEvent;
import org.scijava.platform.event.AppPrintEvent;
import org.scijava.platform.event.AppQuitEvent;
import org.scijava.platform.event.AppReOpenEvent;
import org.scijava.platform.event.AppScreenSleepEvent;
import org.scijava.platform.event.AppSystemSleepEvent;
import org.scijava.platform.event.AppUserSessionEvent;
import org.scijava.platform.event.AppVisibleEvent;

public class MacOSAppEventDispatcher
implements AboutHandler,
AppForegroundListener,
AppHiddenListener,
AppReOpenedListener,
PreferencesHandler,
PrintFilesHandler,
QuitHandler,
ScreenSleepListener,
SystemSleepListener,
UserSessionListener,
OpenFilesHandler {
    private final EventService eventService;

    public MacOSAppEventDispatcher(EventService eventService) {
        this(Application.getApplication(), eventService);
    }

    public MacOSAppEventDispatcher(Application app, EventService eventService) {
        this.eventService = eventService;
        app.setAboutHandler((AboutHandler)this);
        app.setPreferencesHandler((PreferencesHandler)this);
        app.setPrintFileHandler((PrintFilesHandler)this);
        app.setQuitHandler((QuitHandler)this);
        app.addAppEventListener((AppEventListener)this);
        app.setOpenFileHandler((OpenFilesHandler)this);
    }

    public void handleAbout(AppEvent.AboutEvent e) {
        this.eventService.publish((SciJavaEvent)new AppAboutEvent());
    }

    public void handlePreferences(AppEvent.PreferencesEvent e) {
        this.eventService.publish((SciJavaEvent)new AppPreferencesEvent());
    }

    public void printFiles(AppEvent.PrintFilesEvent e) {
        this.eventService.publish((SciJavaEvent)new AppPrintEvent());
    }

    public void handleQuitRequestWith(AppEvent.QuitEvent e, QuitResponse r) {
        this.eventService.publish((SciJavaEvent)new AppQuitEvent());
        r.cancelQuit();
    }

    public void userSessionActivated(AppEvent.UserSessionEvent e) {
        this.eventService.publish((SciJavaEvent)new AppUserSessionEvent(true));
    }

    public void userSessionDeactivated(AppEvent.UserSessionEvent e) {
        this.eventService.publish((SciJavaEvent)new AppUserSessionEvent(false));
    }

    public void systemAboutToSleep(AppEvent.SystemSleepEvent e) {
        this.eventService.publish((SciJavaEvent)new AppSystemSleepEvent(true));
    }

    public void systemAwoke(AppEvent.SystemSleepEvent e) {
        this.eventService.publish((SciJavaEvent)new AppSystemSleepEvent(false));
    }

    public void systemAweoke(AppEvent.SystemSleepEvent e) {
    }

    public void screenAboutToSleep(AppEvent.ScreenSleepEvent e) {
        this.eventService.publish((SciJavaEvent)new AppScreenSleepEvent(true));
    }

    public void screenAwoke(AppEvent.ScreenSleepEvent e) {
        this.eventService.publish((SciJavaEvent)new AppScreenSleepEvent(false));
    }

    public void appHidden(AppEvent.AppHiddenEvent e) {
        this.eventService.publish((SciJavaEvent)new AppVisibleEvent(false));
    }

    public void appUnhidden(AppEvent.AppHiddenEvent e) {
        this.eventService.publish((SciJavaEvent)new AppVisibleEvent(true));
    }

    public void appMovedToBackground(AppEvent.AppForegroundEvent e) {
        this.eventService.publish((SciJavaEvent)new AppFocusEvent(false));
    }

    public void appRaisedToForeground(AppEvent.AppForegroundEvent e) {
        this.eventService.publish((SciJavaEvent)new AppFocusEvent(true));
    }

    public void appReOpened(AppEvent.AppReOpenedEvent e) {
        this.eventService.publish((SciJavaEvent)new AppReOpenEvent());
    }

    public void openFiles(AppEvent.OpenFilesEvent event) {
        this.eventService.publish((SciJavaEvent)new AppOpenFilesEvent(event.getFiles()));
    }
}

