/*
 * Decompiled with CFR 0.152.
 */
import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.MultiLineLabel;
import ij.plugin.PlugIn;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import stitching.CommonFunctions;
import stitching.GridLayout;
import stitching.ImageInformation;
import stitching.model.Model;
import stitching.model.TranslationModel2D;
import stitching.model.TranslationModel3D;
import stitching.utils.Log;

public class Stitch_Image_Directory
implements PlugIn {
    private String myURL = "http://fly.mpi-cbg.de/~preibisch/contact.html";
    public static String imageDirectoryStatic = "";
    public static String rgbOrderStatic = CommonFunctions.rgbTypes[0];
    public static String tileConfStatic = "TileConfiguration.txt";
    public static String handleRGBStatic = CommonFunctions.colorList[CommonFunctions.colorList.length - 1];
    public static String fusionMethodStatic = CommonFunctions.methodListCollection[1];
    public static double alphaStatic = 1.5;
    public static double thresholdRStatic = 0.3;
    public static double thresholdDisplacementRelativeStatic = 2.5;
    public static double thresholdDisplacementAbsoluteStatic = 3.5;

    public void run(String arg0) {
        String fusionMethod;
        String handleRGB;
        String output;
        String imageDir;
        GenericDialogPlus gd = new GenericDialogPlus("Stitch Directory with Images (unknown configuration)");
        GridLayout gridLayout = new GridLayout();
        gd.addDirectoryField("image_directory", imageDirectoryStatic, 50);
        gd.addStringField("output_file_name", tileConfStatic, 50);
        gd.addChoice("rgb_order", CommonFunctions.rgbTypes, rgbOrderStatic);
        gd.addChoice("channels_for_registration", CommonFunctions.colorList, handleRGBStatic);
        gd.addChoice("fusion_method", CommonFunctions.methodListCollection, fusionMethodStatic);
        gd.addNumericField("fusion_alpha", alphaStatic, 2);
        gd.addNumericField("regression_threshold", thresholdRStatic, 2);
        gd.addNumericField("max/avg_displacement_threshold", thresholdDisplacementRelativeStatic, 2);
        gd.addNumericField("absolute_displacement_threshold", thresholdDisplacementAbsoluteStatic, 2);
        gd.addMessage("");
        gd.addMessage("This Plugin is developed by Stephan Preibisch\n" + this.myURL);
        MultiLineLabel text = (MultiLineLabel)gd.getMessage();
        CommonFunctions.addHyperLinkListener(text, this.myURL);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        imageDirectoryStatic = imageDir = gd.getNextString();
        tileConfStatic = output = gd.getNextString();
        rgbOrderStatic = gridLayout.rgbOrder = gd.getNextChoice();
        handleRGBStatic = handleRGB = gd.getNextChoice();
        fusionMethodStatic = fusionMethod = gd.getNextChoice();
        alphaStatic = gridLayout.alpha = gd.getNextNumber();
        thresholdRStatic = gridLayout.thresholdR = gd.getNextNumber();
        thresholdDisplacementRelativeStatic = gridLayout.thresholdDisplacementRelative = gd.getNextNumber();
        thresholdDisplacementAbsoluteStatic = gridLayout.thresholdDisplacementAbsolute = gd.getNextNumber();
        File dir = new File(imageDir);
        if (!dir.isDirectory()) {
            IJ.error((String)("'" + imageDir + "' is not a directory. stop."));
            return;
        }
        String[] imageFiles = dir.list();
        ArrayList<String> files = new ArrayList<String>();
        for (String fileName : imageFiles) {
            File file = new File(dir, fileName);
            if (!file.isFile() || file.isHidden()) continue;
            Log.info(file.getPath());
            files.add(fileName);
        }
        Log.info("Found " + files.size() + " files.");
        if (files.size() < 2) {
            IJ.error((String)("Only " + files.size() + " files found in '" + dir.getPath() + "' stop."));
            return;
        }
        gridLayout.sizeX = files.size();
        gridLayout.sizeY = 1;
        gridLayout.fusionMethod = fusionMethod;
        gridLayout.handleRGB = handleRGB;
        gridLayout.imageInformationList = new ArrayList();
        String fileName = new File(imageDir, output).getPath();
        PrintWriter out = Stitch_Image_Directory.openFileWrite(fileName);
        boolean seenFirst = false;
        int i = 0;
        int dim = 0;
        for (String file : files) {
            if (file.contains("TileConfiguration.txt")) continue;
            if (!seenFirst) {
                ImagePlus imp = CommonFunctions.loadImage(dir.getPath(), file, -1, gridLayout.rgbOrder);
                if (imp == null) {
                    Log.error("Cannot read: " + file + ", trying next one...");
                    continue;
                }
                seenFirst = true;
                gridLayout.dim = imp.getStackSize() > 1 ? 3 : 2;
                dim = imp.getStackSize() > 1 ? 3 : 2;
                if (out != null) {
                    out.println("# Define the number of dimensions we are working on");
                    out.println("dim = " + dim);
                    out.println("");
                    out.println("# Define the image coordinates");
                }
                imp.close();
            }
            if (out != null) {
                if (dim == 3) {
                    out.println(new File(imageDir, file).getPath() + "; ; (" + 0 + ", " + 0 + ", " + 0 + ")");
                } else {
                    out.println(new File(imageDir, file).getPath() + "; ; (" + 0 + ", " + 0 + ")");
                }
            }
            ImageInformation iI = dim == 3 ? new ImageInformation(3, i, (Model)new TranslationModel3D()) : new ImageInformation(2, i, (Model)new TranslationModel2D());
            iI.imageName = new File(imageDir, file).getPath();
            iI.imp = null;
            iI.offset[0] = 0.0f;
            iI.offset[1] = 0.0f;
            iI.position[0] = 0.0f;
            iI.position[1] = 0.0f;
            if (dim == 3) {
                iI.offset[2] = 0.0f;
                iI.position[2] = 0.0f;
            }
            gridLayout.imageInformationList.add(iI);
            ++i;
        }
        if (out != null) {
            out.close();
        }
        Stitch_Image_Collection smc = new Stitch_Image_Collection();
        smc.work(gridLayout, false, true, fileName, true);
    }

    private static PrintWriter openFileWrite(String fileName) {
        PrintWriter outputFile;
        try {
            outputFile = new PrintWriter(new FileWriter(fileName));
        }
        catch (IOException e) {
            IJ.error((String)("CreateGridLayout.openFileWrite(): " + e));
            outputFile = null;
        }
        return outputFile;
    }
}

