/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.stitching;

import ij.ImagePlus;
import java.io.File;
import loci.formats.ChannelSeparator;
import loci.plugins.BF;
import loci.plugins.in.ImporterOptions;
import mpicbg.models.Model;
import stitching.utils.Log;

public class ImageCollectionElement {
    final File file;
    ImagePlus imp = null;
    final int index;
    Model<?> model;
    int dimensionality;
    boolean virtual = false;
    float[] offset;
    int[] size;

    public ImageCollectionElement(File file, int index) {
        this.file = file;
        this.index = index;
    }

    public void setOffset(float[] offset) {
        this.offset = offset;
    }

    public float[] getOffset() {
        return this.offset;
    }

    public float getOffset(int dim) {
        return this.offset[dim];
    }

    public int[] getDimensions() {
        return this.size;
    }

    public int getDimension(int dim) {
        return this.size[dim];
    }

    public int getIndex() {
        return this.index;
    }

    public void setModel(Model<?> model) {
        this.model = model;
    }

    public Model<?> getModel() {
        return this.model;
    }

    public void setDimensionality(int dimensionality) {
        this.dimensionality = dimensionality;
    }

    public int getDimensionality() {
        return this.dimensionality;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setImagePlus(ImagePlus imp) {
        this.imp = imp;
        this.size = imp.getNSlices() == 1 ? new int[]{imp.getWidth(), imp.getHeight()} : new int[]{imp.getWidth(), imp.getHeight(), imp.getNSlices()};
    }

    public ImagePlus open(boolean virtual) {
        if (this.imp != null && this.isVirtual() == virtual) {
            return this.imp;
        }
        if (this.imp != null) {
            this.imp.close();
        }
        this.virtual = virtual;
        try {
            if (!this.file.exists()) {
                Log.error("Cannot find file: '" + this.file + "' - abort stitching.");
                return null;
            }
            ImporterOptions options = new ImporterOptions();
            options.setId(this.file.getAbsolutePath());
            options.setSplitChannels(false);
            options.setSplitTimepoints(false);
            options.setSplitFocalPlanes(false);
            options.setAutoscale(false);
            options.setVirtual(virtual);
            ImagePlus[] imp = virtual ? BF.openImagePlus((ImporterOptions)options) : BF.openImagePlus((String)this.file.getAbsolutePath());
            if (imp.length > 1) {
                Log.error("LOCI does not open the file '" + this.file + "'correctly, it opens the image and splits it - maybe you should convert all input files first to TIFF?");
                for (ImagePlus i : imp) {
                    i.close();
                }
                return null;
            }
            if (imp[0].getNSlices() == 1 && imp[0].getNFrames() > 1) {
                try {
                    ChannelSeparator r = new ChannelSeparator();
                    r.setId(this.file.getAbsolutePath());
                    if (!r.isOrderCertain()) {
                        Log.info("dimension order is not certain, assuming XYZ instead of XYT");
                        imp[0].setDimensions(imp[0].getNChannels(), imp[0].getNFrames(), imp[0].getNSlices());
                    }
                    r.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.size = imp[0].getNSlices() == 1 ? new int[]{imp[0].getWidth(), imp[0].getHeight()} : new int[]{imp[0].getWidth(), imp[0].getHeight(), imp[0].getNSlices()};
            this.imp = imp[0];
            return this.imp;
        }
        catch (Exception e) {
            Log.error("Cannot open file '" + this.file + "': " + e);
            return null;
        }
    }

    public void close() {
        this.imp.close();
        this.imp = null;
    }
}

