/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.stitching.fusion;

import fiji.stacks.Hyperstack_rearranger;
import ij.CompositeImage;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.models.InvertibleBoundable;
import mpicbg.models.InvertibleCoordinateTransform;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.stitching.fusion.Fusion;
import net.imglib2.Cursor;
import net.imglib2.EuclideanSpace;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;
import net.imglib2.exception.ImgLibException;
import net.imglib2.img.Img;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.img.imageplus.ImagePlusImg;
import net.imglib2.img.imageplus.ImagePlusImgFactory;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.multithreading.Chunk;
import net.imglib2.multithreading.SimpleMultiThreading;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;
import stitching.utils.CompositeImageFixer;
import stitching.utils.Log;

public class OverlayFusion {
    protected static <T extends RealType<T> & NativeType<T>> CompositeImage createOverlay(T targetType, ImagePlus imp1, ImagePlus imp2, InvertibleBoundable finalModel1, InvertibleBoundable finalModel2, int dimensionality) {
        ArrayList<ImagePlus> images = new ArrayList<ImagePlus>();
        images.add(imp1);
        images.add(imp2);
        ArrayList<InvertibleBoundable> models = new ArrayList<InvertibleBoundable>();
        models.add(finalModel1);
        models.add(finalModel2);
        return OverlayFusion.createOverlay(targetType, images, models, dimensionality, 1, (InterpolatorFactory<FloatType, RandomAccessible<FloatType>>)new NLinearInterpolatorFactory());
    }

    public static <T extends RealType<T> & NativeType<T>> ImagePlus createReRegisteredSeries(T targetType, ImagePlus imp, ArrayList<InvertibleBoundable> models, int dimensionality) {
        int numImages = imp.getNFrames();
        int[] size = new int[dimensionality];
        double[] offset = new double[dimensionality];
        int[][] imgSizes = new int[numImages][dimensionality];
        for (int i = 0; i < numImages; ++i) {
            imgSizes[i][0] = imp.getWidth();
            imgSizes[i][1] = imp.getHeight();
            if (dimensionality != 3) continue;
            imgSizes[i][2] = imp.getNSlices();
        }
        Fusion.estimateBounds(offset, size, imgSizes, models, dimensionality);
        ImagePlusImgFactory f = new ImagePlusImgFactory();
        ImageStack stack = new ImageStack(size[0], size[1]);
        for (int t = 1; t <= numImages; ++t) {
            for (int c = 1; c <= imp.getNChannels(); ++c) {
                Img out = f.create(size, targetType);
                Img in = ImageJFunctions.convertFloat((ImagePlus)Hyperstack_rearranger.getImageChunk((ImagePlus)imp, (int)c, (int)t));
                OverlayFusion.fuseChannel(out, (RealRandomAccessible<FloatType>)Views.interpolate((EuclideanSpace)Views.extendZero((RandomAccessibleInterval)in), (InterpolatorFactory)new NLinearInterpolatorFactory()), offset, (InvertibleCoordinateTransform)models.get(t - 1));
                try {
                    ImagePlus outImp = ((ImagePlusImg)out).getImagePlus();
                    int z = 1;
                    while ((long)z <= out.dimension(2)) {
                        stack.addSlice(imp.getTitle(), outImp.getStack().getProcessor(z));
                        ++z;
                    }
                    continue;
                }
                catch (ImgLibException e) {
                    Log.error("Output image has no ImageJ type: " + (Object)((Object)e));
                }
            }
        }
        ImagePlus result = new ImagePlus("registered " + imp.getTitle(), stack);
        if (dimensionality == 3) {
            result.setDimensions(size[2], imp.getNChannels(), imp.getNFrames());
            result = OverlayFusion.switchZCinXYCZT(result);
            return CompositeImageFixer.makeComposite(result, 1);
        }
        result.setDimensions(imp.getNChannels(), 1, imp.getNFrames());
        if (imp.getNChannels() > 1) {
            return CompositeImageFixer.makeComposite(result, 1);
        }
        return result;
    }

    public static <T extends RealType<T> & NativeType<T>> CompositeImage createOverlay(T targetType, ArrayList<ImagePlus> images, ArrayList<InvertibleBoundable> models, int dimensionality, int timepoint, InterpolatorFactory<FloatType, RandomAccessible<FloatType>> factory) {
        int numImages = images.size();
        int[] size = new int[dimensionality];
        double[] offset = new double[dimensionality];
        Fusion.estimateBounds(offset, size, images, models, dimensionality);
        ImagePlusImgFactory f = new ImagePlusImgFactory();
        ImageStack stack = new ImageStack(size[0], size[1]);
        int numChannels = 0;
        for (int i = 0; i < images.size(); ++i) {
            ImagePlus imp = images.get(i);
            for (int c = 1; c <= imp.getNChannels(); ++c) {
                Img out = f.create(size, targetType);
                Img in = ImageJFunctions.convertFloat((ImagePlus)Hyperstack_rearranger.getImageChunk((ImagePlus)imp, (int)c, (int)timepoint));
                OverlayFusion.fuseChannel(out, (RealRandomAccessible<FloatType>)Views.interpolate((EuclideanSpace)Views.extendZero((RandomAccessibleInterval)in), factory), offset, (InvertibleCoordinateTransform)models.get(i + (timepoint - 1) * numImages));
                try {
                    ImagePlus outImp = ((ImagePlusImg)out).getImagePlus();
                    int z = 1;
                    while ((long)z <= out.dimension(2)) {
                        stack.addSlice(imp.getTitle(), outImp.getStack().getProcessor(z));
                        ++z;
                    }
                }
                catch (ImgLibException e) {
                    Log.error("Output image has no ImageJ type: " + (Object)((Object)e));
                }
                ++numChannels;
            }
        }
        ImagePlus result = new ImagePlus("overlay " + images.get(0).getTitle() + " ... " + images.get(numImages - 1).getTitle(), stack);
        if (dimensionality == 3) {
            result.setDimensions(size[2], numChannels, 1);
            result = OverlayFusion.switchZCinXYCZT(result);
        } else {
            result.setDimensions(numChannels, 1, 1);
        }
        return CompositeImageFixer.makeComposite(result, 1);
    }

    protected static <T extends RealType<T>> void fuseChannel(final Img<T> output, final RealRandomAccessible<FloatType> input, final double[] offset, final InvertibleCoordinateTransform transform) {
        final int dims = output.numDimensions();
        long imageSize = output.dimension(0);
        for (int d = 1; d < output.numDimensions(); ++d) {
            imageSize *= output.dimension(d);
        }
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads();
        final Vector threadChunks = SimpleMultiThreading.divideIntoChunks((long)imageSize, (int)threads.length);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    Chunk myChunk = (Chunk)threadChunks.get(myNumber);
                    long startPos = myChunk.getStartPosition();
                    long loopSize = myChunk.getLoopSize();
                    Cursor out = output.localizingCursor();
                    RealRandomAccess in = input.realRandomAccess();
                    double[] tmp = new double[input.numDimensions()];
                    try {
                        out.jumpFwd(startPos);
                        for (long j = 0L; j < loopSize; ++j) {
                            out.fwd();
                            for (int d = 0; d < dims; ++d) {
                                tmp[d] = out.getDoublePosition(d) + offset[d];
                            }
                            transform.applyInverseInPlace(tmp);
                            in.setPosition(tmp);
                            ((RealType)out.get()).setReal(((FloatType)in.get()).get());
                        }
                    }
                    catch (NoninvertibleModelException e) {
                        Log.error("Cannot invert model, qutting.");
                        return;
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
    }

    public static ImagePlus switchZCinXYCZT(ImagePlus imp) {
        int numChannels = imp.getNChannels();
        int numTimepoints = imp.getNFrames();
        int numZStacks = imp.getNSlices();
        String newTitle = imp.getTitle().startsWith("[XYZCT]") ? imp.getTitle().substring(8, imp.getTitle().length()) : "[XYZCT] " + imp.getTitle();
        if (numChannels == 1 && numZStacks == 1) {
            return imp;
        }
        if (numChannels == 1 || numZStacks == 1) {
            imp.setDimensions(numZStacks, numChannels, numTimepoints);
            imp.setTitle(newTitle);
            return imp;
        }
        ImageStack stack = new ImageStack(imp.getWidth(), imp.getHeight());
        for (int t = 1; t <= numTimepoints; ++t) {
            for (int c = 1; c <= numChannels; ++c) {
                for (int z = 1; z <= numZStacks; ++z) {
                    int index = imp.getStackIndex(c, z, t);
                    ImageProcessor ip = imp.getStack().getProcessor(index);
                    stack.addSlice(imp.getStack().getSliceLabel(index), ip);
                }
            }
        }
        ImagePlus result = new ImagePlus(newTitle, stack);
        result.setDimensions(numZStacks, numChannels, numTimepoints);
        result.getCalibration().pixelWidth = imp.getCalibration().pixelWidth;
        result.getCalibration().pixelHeight = imp.getCalibration().pixelHeight;
        result.getCalibration().pixelDepth = imp.getCalibration().pixelDepth;
        CompositeImage composite = CompositeImageFixer.makeComposite(result);
        return composite;
    }

    public static ImagePlus switchZTinXYCZT(ImagePlus imp) {
        int numChannels = imp.getNChannels();
        int numTimepoints = imp.getNFrames();
        int numZStacks = imp.getNSlices();
        String newTitle = imp.getTitle().startsWith("[XYCTZ]") ? imp.getTitle().substring(8, imp.getTitle().length()) : "[XYCTZ] " + imp.getTitle();
        if (numTimepoints == 1 && numZStacks == 1) {
            return imp;
        }
        if (numTimepoints == 1 || numZStacks == 1) {
            imp.setDimensions(numChannels, numTimepoints, numZStacks);
            imp.setTitle(newTitle);
            return imp;
        }
        ImageStack stack = new ImageStack(imp.getWidth(), imp.getHeight());
        for (int z = 1; z <= numZStacks; ++z) {
            for (int t = 1; t <= numTimepoints; ++t) {
                for (int c = 1; c <= numChannels; ++c) {
                    int index = imp.getStackIndex(c, z, t);
                    ImageProcessor ip = imp.getStack().getProcessor(index);
                    stack.addSlice(imp.getStack().getSliceLabel(index), ip);
                }
            }
        }
        ImagePlus result = new ImagePlus(newTitle, stack);
        result.setDimensions(numChannels, numTimepoints, numZStacks);
        result.getCalibration().pixelWidth = imp.getCalibration().pixelWidth;
        result.getCalibration().pixelHeight = imp.getCalibration().pixelHeight;
        result.getCalibration().pixelDepth = imp.getCalibration().pixelDepth;
        CompositeImage composite = CompositeImageFixer.makeComposite(result);
        return composite;
    }
}

