/*
 * Decompiled with CFR 0.152.
 */
package util;

public class FibonacciHeapDouble {
    private Node root = new Node(0.0, null, null);
    private Node min;
    int count;

    public void add(double key, Object object) {
        Node node = new Node(key, object, this.root);
        if (this.min == null || this.min.key - key > 0.0) {
            this.min = node;
        }
        this.root.insertChild(node);
        ++this.count;
    }

    public Object pop() {
        if (this.min == null) {
            return null;
        }
        Node node = this.min.firstChild;
        while (node != null) {
            Node next = node.next;
            node.previous = null;
            node.next = null;
            node.parent = null;
            this.root.firstChild.insert(node);
            node = next;
        }
        Node ret = this.min;
        if (this.root.firstChild == this.min) {
            this.root.firstChild = this.min.next;
            if (this.min.next != null) {
                this.min.next.previous = null;
            }
        } else {
            if (this.min.next != null) {
                this.min.next.previous = this.min.previous;
            }
            if (this.min.previous != null) {
                this.min.previous.next = this.min.next;
            }
        }
        if (this.root.firstChild != null) {
            this.consolidate();
        } else {
            this.min = null;
        }
        --this.count;
        return ret.object;
    }

    public boolean hasMore() {
        return this.root.firstChild != null;
    }

    public double compareTo(double other) {
        return this.min == null ? 1.0 : this.min.key - other;
    }

    private final Node link(Node a, Node b) {
        if (a.key - b.key > 0.0) {
            return this.link(b, a);
        }
        b.extract();
        b.parent = a;
        a.insertChild(b);
        return a;
    }

    private final void insert(Node[] list, Node node) {
        if (list[node.degree] == null) {
            list[node.degree] = node;
        } else {
            int oldDegree = node.degree;
            node = this.link(node, list[oldDegree]);
            list[oldDegree] = null;
            this.insert(list, node);
        }
    }

    private final void consolidate() {
        int maxDegree = 1;
        for (int i = 1; i <= this.count; i *= 2) {
            ++maxDegree;
        }
        Node[] list = new Node[maxDegree];
        Node n = this.root.firstChild;
        while (n != null) {
            Node next = n.next;
            n.extract();
            n.parent = this.root;
            this.insert(list, n);
            n = next;
        }
        Node last = null;
        this.root.firstChild = null;
        for (int i = 0; i < maxDegree; ++i) {
            if (list[i] == null) continue;
            if (last == null) {
                last = this.root.firstChild = list[i];
                last.next = null;
                last.previous = null;
                this.min = last;
                continue;
            }
            last.next = list[i];
            list[i].previous = last;
            last = list[i];
            last.next = null;
            if (!(this.min.key - last.key > 0.0)) continue;
            this.min = last;
        }
    }

    public static void main(String[] args) {
        int i;
        FibonacciHeapDouble heap = new FibonacciHeapDouble();
        double[] prios = new double[]{9.0, -5.0, Math.PI, 132.0, 15.223, 900000.0, 1997.0, 0.001, 0.0012, 0.0};
        for (i = 0; i < prios.length; ++i) {
            Double p = new Double(prios[i]);
            heap.add(prios[i], new Double((int)prios[i]));
        }
        i = 0;
        while (heap.hasMore()) {
            System.out.println("Extract " + ++i + ": " + (Double)heap.pop());
        }
    }

    private static class Node {
        double key;
        Object object;
        Node next;
        Node previous;
        Node parent;
        Node firstChild;
        int degree;
        boolean marked;

        public Node(double key, Object object, Node parent) {
            this.key = key;
            this.object = object;
            this.parent = parent;
        }

        void insert(Node node) {
            if (node.next != null || node.previous != null || node.parent != null && node.parent != this.parent || this.previous != null) {
                throw new RuntimeException("node not new: " + node.next + ", " + node.previous + ", " + node.parent + ", " + this.previous);
            }
            node.next = this;
            this.previous = node;
            node.parent = this.parent;
            this.parent.firstChild = node;
        }

        void insertChild(Node node) {
            if (this.firstChild == null) {
                this.firstChild = node;
                this.degree = node.degree + 1;
            } else {
                this.firstChild.insert(node);
                if (node.degree + 1 > this.degree) {
                    this.degree = node.degree + 1;
                }
            }
        }

        final void extract() {
            if (this.parent != null && this.parent.firstChild == this) {
                this.parent.firstChild = this.next;
            }
            if (this.next != null) {
                this.next.previous = this.previous;
            }
            if (this.previous != null) {
                this.previous.next = this.next;
            }
            this.parent = null;
            this.next = null;
            this.previous = null;
        }

        public void print(String label) {
            this.print(label, "");
        }

        public void print(String label, String indent) {
            System.out.println(indent + label + ": " + this.key + ", " + this.object);
            int i = 1;
            Node n = this.firstChild;
            while (n != null) {
                n.print(label + ":" + i++, indent + "    ");
                n = n.next;
            }
        }
    }
}

