/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.util.Tools;

public class RATS_
implements PlugInFilter {
    ImagePlus imp;
    ImageProcessor ip;
    ImageProcessor topIp;
    ImageProcessor botIp;
    ImageProcessor threshIp;
    RATSQuadtree qtTop;
    RATSQuadtree qtBot;
    private boolean bVerbose = false;
    private double[] minSzPx = new double[]{32.0, 32.0};
    private double sigma = 25.0;
    private double lambda = 3.0;
    float[][] p;
    float[][] top;
    float[][] bot;
    int[] dim = new int[2];
    long startTime = System.currentTimeMillis();

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 13;
    }

    public void run(ImageProcessor ip) {
        this.ip = ip;
        this.dim[0] = ip.getWidth();
        this.dim[1] = ip.getHeight();
        this.minSzPx[0] = (double)this.dim[0] / 5.0;
        this.minSzPx[1] = (double)this.dim[1] / 5.0;
        if (this.minSzPx[0] < this.minSzPx[1]) {
            this.minSzPx[1] = this.minSzPx[0];
        } else {
            this.minSzPx[0] = this.minSzPx[1];
        }
        String opt = Macro.getOptions();
        if (opt != null && opt.length() != 0) {
            String[] opts = opt.split(" ");
            for (int i = 0; i < opts.length; ++i) {
                String[] s = opts[i].split("=");
                if (s[0].equalsIgnoreCase("noise")) {
                    this.sigma = Tools.parseDouble((String)s[1]);
                    continue;
                }
                if (s[0].equalsIgnoreCase("lambda")) {
                    this.lambda = Tools.parseDouble((String)s[1]);
                    continue;
                }
                if (s[0].equalsIgnoreCase("minSzPx")) {
                    this.minSzPx[0] = Tools.parseDouble((String)s[1]);
                    this.minSzPx[1] = this.minSzPx[0];
                    continue;
                }
                if (s[0].equalsIgnoreCase("min")) {
                    this.minSzPx[0] = Tools.parseDouble((String)s[1]);
                    this.minSzPx[1] = this.minSzPx[0];
                    continue;
                }
                if (s[0].equalsIgnoreCase("verbose")) {
                    this.bVerbose = true;
                    continue;
                }
                IJ.log((String)("oops! unrecognized argument: " + opts[i]));
            }
        } else if (!this.showDialog()) {
            return;
        }
        this.qtTop = new RATSQuadtree(this.dim, this.minSzPx);
        this.qtBot = new RATSQuadtree(this.dim, this.minSzPx);
        if (this.bVerbose) {
            IJ.log((String)"**** RATS ****");
            IJ.log((String)("  Image = " + this.imp.getTitle()));
            IJ.log((String)("  Noise = " + this.sigma));
            IJ.log((String)("  Lambda = " + this.lambda));
            IJ.log((String)("  Min Leaf Size = " + this.minSzPx[0]));
            IJ.log((String)("  NLevels = " + this.qtTop.countLevels()));
        }
        long startTime = System.currentTimeMillis();
        this.process();
        if (this.bVerbose) {
            long elapsed = System.currentTimeMillis() - startTime;
            IJ.log((String)("  Elapsed time = " + elapsed + " ms for processing"));
        }
    }

    private void process() {
        this.tick();
        this.fillArrays();
        if (this.bVerbose) {
            this.tock("  FillArrays:");
        }
        this.tick();
        this.gradientMHFW();
        if (this.bVerbose) {
            this.tock("  Gradient:");
        }
        this.tick();
        this.topIp = new FloatProcessor(this.top);
        this.qtTop.fillWithSums(this.topIp);
        this.botIp = new FloatProcessor(this.bot);
        this.qtBot.fillWithSums(this.botIp);
        if (this.bVerbose) {
            this.tock("  FillWithSums:");
        }
        this.tick();
        float[][] thresh = this.rats();
        if (this.bVerbose) {
            this.tock("  Rats:");
        }
        this.tick();
        thresh = this.resize(thresh);
        if (this.bVerbose) {
            this.tock("  Resize:");
        }
        this.threshIp = new FloatProcessor(thresh);
        String title = this.imp.getShortTitle() + "-mask";
        ImagePlus resultImp = new ImagePlus(title, this.threshIp.convertToByte(true));
        resultImp.show();
    }

    private float[][] resize(float[][] in) {
        int x;
        int oh = this.dim[1];
        int ow = this.dim[0];
        int iw = in.length;
        int ih = in[0].length;
        float[][] out = new float[ow][oh];
        float[] sx = new float[ow];
        float[] sy = new float[oh];
        int[] ix = new int[ow];
        int[] iy = new int[oh];
        float r = 0.0f;
        float gx = 0.0f;
        float gy = 0.0f;
        float dx = 0.0f;
        float dy = 0.0f;
        float one = 1.0f;
        float on = 255.0f;
        for (x = 0; x < ow; ++x) {
            sx[x] = (float)x / (float)(ow - 1) * (float)(iw - 1);
            ix[x] = (int)sx[x];
        }
        sx[ow - 1] = sx[ow - 2] + 0.99f * (sx[ow - 1] - sx[ow - 2]);
        ix[ow - 1] = (int)sx[ow - 1];
        for (int y = 0; y < oh; ++y) {
            sy[y] = (float)y / (float)(oh - 1) * (float)(ih - 1);
            iy[y] = (int)sy[y];
        }
        sy[oh - 1] = sy[oh - 2] + 0.99f * (sy[oh - 1] - sy[oh - 2]);
        iy[oh - 1] = (int)sy[oh - 1];
        for (x = 0; x < ow; ++x) {
            for (int y = 0; y < oh; ++y) {
                dx = ((float)(ix[x] + 1) - sx[x]) * in[ix[x]][iy[y]] + (sx[x] - (float)ix[x]) * in[ix[x] + 1][iy[y]];
                gx = ((float)(ix[x] + 1) - sx[x]) * in[ix[x]][iy[y] + 1] + (sx[x] - (float)ix[x]) * in[ix[x] + 1][iy[y] + 1];
                r = ((float)(iy[y] + 1) - sy[y]) * dx + (sy[y] - (float)iy[y]) * gx;
                if (!(r < this.p[x][y])) continue;
                out[x][y] = on;
            }
        }
        return out;
    }

    private float[][] rats() {
        int depth = this.qtTop.countLevels();
        RATSQuadtree[][] qTop = this.qtTop.getLevel(depth - 1);
        RATSQuadtree[][] qBot = this.qtBot.getLevel(depth - 1);
        float[][] threshP = this.qtTop.makeArrayFloat(depth - 1);
        float test = (float)(3.0 * this.lambda * this.sigma * this.lambda * this.sigma);
        for (int x = 0; x < threshP.length; ++x) {
            for (int y = 0; y < threshP[0].length; ++y) {
                threshP[x][y] = this.ratsThresh(qTop[x][y], qBot[x][y], test);
            }
        }
        return threshP;
    }

    private float ratsThresh(RATSQuadtree qTop, RATSQuadtree qBot, float test) {
        float topV = qTop.getSumFloat();
        float botV = qBot.getSumFloat();
        if (botV > test) {
            return topV / botV;
        }
        if (qTop.getLevel() == 0) {
            return -1.0f;
        }
        return this.ratsThresh(qTop.getParent(), qBot.getParent(), test);
    }

    private void gradientMHFW() {
        float tempG = 0.0f;
        float wx = 0.0f;
        float wy = 0.0f;
        int xL = 0;
        int xR = 0;
        int yU = 0;
        int yD = 0;
        float scale = 0.0625f;
        float lambdasigma = (float)(this.lambda * this.sigma * this.lambda * this.sigma);
        int w = this.dim[0];
        int h = this.dim[1];
        int wm1 = w - 1;
        int hm1 = h - 1;
        float two = 2.0f;
        for (int y = 0; y < h; ++y) {
            if (y % hm1 == 0) {
                yU = y - (y == 0 ? 0 : 1);
                yD = y + (y == hm1 ? 0 : 1);
            } else {
                yU = y - 1;
                yD = y + 1;
            }
            for (int x = 0; x < w; ++x) {
                if (x % wm1 == 0) {
                    xL = x - (x == 0 ? 0 : 1);
                    xR = x + (x == wm1 ? 0 : 1);
                } else {
                    xL = x - 1;
                    xR = x + 1;
                }
                wx = this.p[xL][yU] - this.p[xL][yD] + two * (this.p[x][yU] - this.p[x][yD]) + this.p[xR][yU] - this.p[xR][yD];
                wy = this.p[xL][yU] - this.p[xR][yU] + two * (this.p[xL][y] - this.p[xR][y]) + this.p[xL][yD] - this.p[xR][yD];
                tempG = (wx * wx + wy * wy) * scale;
                if (!(tempG > lambdasigma)) continue;
                this.bot[x][y] = tempG;
                this.top[x][y] = this.p[x][y] * tempG;
            }
        }
    }

    private void fillArrays() {
        this.p = new float[this.dim[0]][this.dim[1]];
        this.top = new float[this.dim[0]][this.dim[1]];
        this.bot = new float[this.dim[0]][this.dim[1]];
        for (int y = 0; y < this.dim[1]; ++y) {
            for (int x = 0; x < this.dim[0]; ++x) {
                this.p[x][y] = this.ip.getPixelValue(x, y);
            }
        }
    }

    private boolean showDialog() {
        GenericDialog gd = new GenericDialog("RATS");
        gd.addNumericField("Noise Threshold:", this.sigma, 0);
        gd.addNumericField("Lambda Factor:", this.lambda, 0);
        gd.addNumericField("Min Leaf Size (pixels):", this.minSzPx[0], 0);
        gd.addCheckbox("Verbose", this.bVerbose);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.sigma = gd.getNextNumber();
        this.lambda = gd.getNextNumber();
        this.minSzPx[0] = gd.getNextNumber();
        this.minSzPx[1] = this.minSzPx[0];
        this.bVerbose = gd.getNextBoolean();
        return true;
    }

    private long tick() {
        this.startTime = System.currentTimeMillis();
        return this.startTime;
    }

    private long tock() {
        return System.currentTimeMillis() - this.startTime;
    }

    private long tock(String message) {
        long elapsedTime = this.tock();
        IJ.log((String)(message + " " + elapsedTime + " ms"));
        return elapsedTime;
    }
}

