/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.uploaders.webdav;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.imagej.plugins.uploaders.webdav.NetrcParser;
import net.imagej.plugins.uploaders.webdav.ProgressHttpEntityWrapper;
import net.imagej.updater.AbstractUploader;
import net.imagej.updater.FilesUploader;
import net.imagej.updater.UpdateSite;
import net.imagej.updater.Uploadable;
import net.imagej.updater.Uploader;
import net.imagej.updater.util.UpdaterUserInterface;
import net.imagej.updater.util.UpdaterUtil;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.jackrabbit.webdav.client.methods.HttpDelete;
import org.apache.jackrabbit.webdav.client.methods.HttpLock;
import org.apache.jackrabbit.webdav.client.methods.HttpMkcol;
import org.apache.jackrabbit.webdav.client.methods.HttpMove;
import org.apache.jackrabbit.webdav.client.methods.HttpOptions;
import org.apache.jackrabbit.webdav.client.methods.HttpPropfind;
import org.apache.jackrabbit.webdav.client.methods.HttpUnlock;
import org.apache.jackrabbit.webdav.lock.LockInfo;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.scijava.log.LogService;
import org.scijava.log.StderrLogService;
import org.scijava.plugin.Plugin;

@Plugin(type=Uploader.class)
public class WebDAVUploader
extends AbstractUploader {
    private String baseURL;
    private String username;
    private String password;
    private final Set<String> existingDirectories;
    private LogService log;
    private boolean debug = false;
    protected static HttpClient client;
    private CredentialsProvider provider;
    ArrayList<String> schemes = new ArrayList();

    public WebDAVUploader() {
        this.provider = new BasicCredentialsProvider();
        int timeout = 360;
        this.schemes.add("Digest");
        this.schemes.add("Basic");
        RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).build();
        client = HttpClientBuilder.create().setDefaultCredentialsProvider(this.provider).setDefaultRequestConfig(config).build();
        this.existingDirectories = new HashSet<String>();
    }

    public String getProtocol() {
        return "webdav";
    }

    public boolean login(FilesUploader uploader) {
        int colon;
        if (!super.login(uploader)) {
            return false;
        }
        this.log = uploader.getLog();
        this.debug = this.log.isDebug();
        String host = uploader.getUploadHost();
        if (!"".equals(host)) {
            this.username = host;
            int colon2 = this.username.indexOf(58);
            if (colon2 < 0) {
                this.password = null;
            } else {
                this.password = this.username.substring(colon2 + 1);
                this.username = this.username.substring(0, colon2);
            }
        }
        UpdateSite site = uploader.getFilesCollection().getUpdateSite(uploader.getSiteName(), true);
        this.setBaseUrl(site.getURL());
        if ((this.username == null || this.password == null) && (colon = this.baseURL.indexOf("://")) > 0) {
            try {
                int slash = this.baseURL.indexOf(47, colon + 3);
                String hostname = this.baseURL.substring(colon + 3, slash < 0 ? this.baseURL.length() : slash);
                NetrcParser netrcParser = new NetrcParser();
                NetrcParser.Credentials credentials = netrcParser.getCredentials(hostname, this.username);
                if (credentials != null) {
                    this.username = credentials.getUsername();
                    this.password = credentials.getPassword();
                }
            }
            catch (IOException e) {
                this.log.warn((Throwable)e);
            }
        }
        if (this.username == null) {
            uploader.getDefaultUsername();
            if (this.username == null) {
                this.username = UpdaterUserInterface.get().getString("Login for " + this.baseURL);
            }
            if (this.username == null) {
                return false;
            }
        }
        if (this.password == null) {
            String prompt = "Password for " + this.username + "@" + this.baseURL;
            this.password = UpdaterUserInterface.get().getPassword(prompt);
            if (this.password == null) {
                return false;
            }
        }
        this.setCredentials(this.username, this.password);
        try {
            if (!this.isAllowed()) {
                UpdaterUserInterface.get().error("User " + this.username + " lacks upload permissions for " + this.baseURL + " or the password is incorrect.");
                return false;
            }
            if (!this.directoryExists("")) {
                UpdaterUserInterface.get().error(this.baseURL + " does not exist yet!");
                return false;
            }
        }
        catch (UnauthenticatedException e) {
            UpdaterUserInterface.get().error("User " + this.username + " lacks upload permissions for " + this.baseURL + " or the password is incorrect.");
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void logout() {
        this.password = null;
        this.username = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void upload(List<Uploadable> sources, List<String> locks) throws IOException {
        String token;
        this.timestamp = -1L;
        HashMap<String, String> tokens = new HashMap<String, String>();
        for (String lock : locks) {
            String path = lock + ".lock";
            token = this.lock(path);
            tokens.put(path, token);
        }
        this.setTitle("Uploading");
        this.calculateTotalSize(sources);
        int count = 0;
        try {
            for (Uploadable source : sources) {
                String target = source.getFilename();
                String token2 = (String)tokens.get(target);
                int slash = target.lastIndexOf(47);
                if (slash > 0 && !this.ensureDirectoryExists(target.substring(0, slash + 1))) {
                    throw new IOException("Could not make subdirectory for " + target);
                }
                this.addItem(source);
                int[] currentCount = new int[]{0};
                int currentTotal = (int)source.getFilesize();
                int finalCount = count;
                ProgressHttpEntityWrapper.ProgressCallback progressCallback = progress -> {
                    currentCount[0] = (int)((float)currentTotal * progress);
                    this.setItemCount(currentCount[0], currentTotal);
                    this.setCount(finalCount + currentCount[0], this.total);
                };
                this.upload(source, token2, progressCallback);
                this.itemDone(source);
                count += currentCount[0];
            }
            this.done();
            this.addItem("Moving locks");
            for (String lock : locks) {
                String source = lock + ".lock";
                if (this.move(source, lock, (String)tokens.get(source), true)) {
                    tokens.remove(source);
                    continue;
                }
                this.log.error((Object)("Could not move " + source + " to " + lock));
            }
        }
        finally {
            for (String key : tokens.keySet()) {
                if (this.unlock(key, token = (String)tokens.get(key))) continue;
                throw new IOException("Could not unlock " + key + " with token " + token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean upload(Uploadable source, String token, ProgressHttpEntityWrapper.ProgressCallback progressCallback) throws IOException {
        InputStreamEntity entity;
        String target = source.getFilename();
        URL url = this.getURL(target, false);
        HttpPut method = new HttpPut(url.toString());
        if (token != null) {
            method.setHeader("If", "<" + url + "> (<" + token + ">)");
        }
        if (source.getFilesize() > 0L) {
            entity = new InputStreamEntity(source.getInputStream(), source.getFilesize());
            entity.setChunked(true);
        } else {
            entity = new BufferedHttpEntity((HttpEntity)new InputStreamEntity(source.getInputStream()));
        }
        if (progressCallback != null) {
            method.setEntity((HttpEntity)new ProgressHttpEntityWrapper((HttpEntity)entity, progressCallback, source.getFilesize()));
        } else {
            method.setEntity((HttpEntity)entity);
        }
        try {
            HttpResponse response = this.runMethodOnClient((HttpUriRequest)method, (HttpContext)this.createStreamingUploadContext());
            int code = response.getStatusLine().getStatusCode();
            if (code != 201 && code != 204) {
                this.log.error((Object)("Code: " + code + " " + response.getStatusLine()));
                throw new IOException("Could not write " + target);
            }
            this.log.info((Object)("Successfully uploaded to " + target + ""));
            boolean bl = true;
            return bl;
        }
        finally {
            method.releaseConnection();
        }
    }

    private HttpClientContext createStreamingUploadContext() {
        HttpClientContext context = this.createContext();
        RequestConfig config = RequestConfig.custom().setExpectContinueEnabled(true).build();
        context.setRequestConfig(config);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String lock(String path) throws IOException {
        boolean success;
        HttpResponse response;
        HttpLock method = new HttpLock(this.getURL(path, false).toString(), new LockInfo(Scope.EXCLUSIVE, Type.WRITE, this.username, 600000L, false));
        try {
            response = this.runMethodOnClient((HttpUriRequest)method);
            success = method.succeeded(response);
        }
        finally {
            method.releaseConnection();
        }
        if (!success) {
            System.err.println("Error obtaining lock for " + path + ": " + response.getStatusLine());
        } else {
            this.log.info((Object)("Successfully locked " + path + "."));
        }
        if (this.timestamp < 0L) {
            Date date = DateUtils.parseDate((String)response.getFirstHeader("Date").getValue());
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            this.timestamp = Long.parseLong(UpdaterUtil.timestamp((Calendar)cal));
            if (this.timestamp < 0L) {
                throw new IOException("Could not obtain date from the server");
            }
        }
        String token = method.getLockToken(response);
        if (this.debug) {
            this.log.info((Object)("Tried to obtain a lock (" + token + "):\n" + response.getEntity().getContent().toString()));
        }
        if (token == null) {
            this.log.error((Object)("Expected lock for '" + path + "', got:\n" + response.getEntity().getContent().toString()));
            throw new IOException("Could not obtain lock for " + path);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unlock(String path, String token) throws IOException {
        boolean success;
        HttpUnlock method = new HttpUnlock(this.getURL(path, false).toString(), token);
        try {
            HttpResponse response = this.runMethodOnClient((HttpUriRequest)method);
            success = method.succeeded(response);
            if (success) {
                this.log.info((Object)("Successfully unlocked " + path + "."));
            } else {
                System.err.println("Error removing lock from " + path + ": " + response.getStatusLine());
            }
        }
        finally {
            method.releaseConnection();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean move(String source, String target, String token, boolean force) throws IOException {
        String url = this.getURL(source, false).toString();
        String targetURL = this.getURL(target, false).toString();
        HttpMove method = new HttpMove(url, targetURL, force);
        if (token != null) {
            method.setHeader("If", "<" + url + "> (<" + token + ">)");
        }
        boolean success = false;
        try {
            HttpResponse response = this.runMethodOnClient((HttpUriRequest)method);
            success = method.succeeded(response);
            if (success) {
                this.log.info((Object)("Successfully moved  " + source + " to " + target + "."));
            } else {
                this.log.error((Object)("Error moving " + source + " to " + target + ": " + response.getStatusLine()));
            }
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
        }
        finally {
            method.releaseConnection();
        }
        return success;
    }

    boolean ensureDirectoryExists(String path) throws IOException {
        if (this.existingDirectories.contains(path)) {
            return true;
        }
        try {
            if (this.directoryExists(path)) {
                this.existingDirectories.add(path);
                return true;
            }
        }
        catch (UnauthenticatedException e) {
            this.log.error((Object)("Could not check if directory " + path + " exists. The given user is unauthorized or the given password is incorrect."));
        }
        int slash = path.lastIndexOf(47, path.length() - 2);
        if (slash > 0 && !this.ensureDirectoryExists(path.substring(0, slash + 1))) {
            return false;
        }
        if (this.makeDirectory(path)) {
            this.existingDirectories.add(path);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean directoryExists(String path) throws IOException, UnauthenticatedException {
        HttpPropfind method = new HttpPropfind(this.getURL(path, true).toString(), 1, 0);
        try {
            HttpResponse response = this.runMethodOnClient((HttpUriRequest)method);
            if (response.getStatusLine().getStatusCode() == 401) {
                this.log.error((Object)("Could not check if directory " + path + " exists. The given user is unauthorized or the given password is incorrect."));
                throw new UnauthenticatedException();
            }
            boolean success = method.succeeded(response);
            if (success) {
                this.log.info((Object)("Successfully called PropFind, directory exists: " + path + "."));
                boolean bl = true;
                return bl;
            }
        }
        finally {
            method.releaseConnection();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isAllowed() throws IOException {
        boolean success;
        HttpOptions method = new HttpOptions(this.baseURL);
        try {
            HttpResponse response = this.runMethodOnClient((HttpUriRequest)method);
            Header header = response.getFirstHeader("Allow");
            if (header == null) {
                success = false;
            } else {
                success = true;
                this.log.info((Object)"Successfully retrieved OPTIONS.");
                String allow = header.getValue();
                if (!allow.contains("LOCK")) {
                    this.log.error((Object)("LOCK action not allowed; valid actions: " + allow));
                    success = false;
                }
            }
        }
        finally {
            method.releaseConnection();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean makeDirectory(String path) throws IOException {
        boolean success;
        HttpMkcol method = new HttpMkcol(this.getURL(path, true).toString());
        try {
            HttpResponse response = this.runMethodOnClient((HttpUriRequest)method);
            success = method.succeeded(response);
        }
        finally {
            method.releaseConnection();
        }
        if (success) {
            this.log.info((Object)("Successfully made directory " + path + "."));
            return true;
        }
        this.log.error((Object)("Failed to make directory " + path + "."));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(String path) throws IOException {
        block5: {
            boolean isDirectory = path.endsWith("/");
            URL target = this.getURL(path, isDirectory);
            HttpDelete method = new HttpDelete(target.toString());
            if (!isDirectory) {
                method.setHeader("Depth", "Infinity");
            }
            try {
                HttpResponse response = this.runMethodOnClient((HttpUriRequest)method);
                if (method.succeeded(response)) {
                    this.log.info((Object)("Successfully deleted " + target + "."));
                    break block5;
                }
                throw new IOException("Could not delete " + target + ": " + response.getStatusLine());
            }
            finally {
                method.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDeleted(String path) throws IOException {
        boolean success;
        boolean isDirectory = path.endsWith("/");
        URL target = this.getURL(path, isDirectory);
        HttpGet method = new HttpGet(target.toString());
        if (!isDirectory) {
            method.setHeader("Depth", "Infinity");
        }
        try {
            HttpResponse response = this.runMethodOnClient((HttpUriRequest)method);
            success = response.getStatusLine().getStatusCode() == 404;
        }
        finally {
            method.releaseConnection();
        }
        return success;
    }

    private HttpClientContext createContext() {
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider(this.provider);
        RequestConfig config = RequestConfig.custom().setExpectContinueEnabled(true).build();
        context.setRequestConfig(config);
        return context;
    }

    HttpResponse runMethodOnClient(HttpUriRequest method) throws IOException {
        return this.runMethodOnClient(method, (HttpContext)this.createContext());
    }

    HttpResponse runMethodOnClient(HttpUriRequest method, HttpContext context) throws IOException {
        method.setHeader("User-Agent", "Java/" + System.getProperty("java.version"));
        if (this.debug) {
            this.log.debug((Object)("Sending request " + method));
            for (Header header : method.getAllHeaders()) {
                this.log.debug((Object)("Header: " + header.getName() + " = " + header.getValue()));
            }
        }
        HttpResponse response = client.execute(method, context);
        if (this.debug) {
            this.log.debug((Object)("Response: " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine()));
            for (Header header : response.getAllHeaders()) {
                this.log.debug((Object)("Header: " + header.getName() + " = " + header.getValue()));
            }
        }
        return response;
    }

    private URL getURL(String path, boolean isDirectory) throws MalformedURLException, UnsupportedEncodingException {
        String url = this.baseURL + URLEncoder.encode(path, "UTF-8").replaceAll("%2F", "/").replaceAll("\\+", "%20");
        if (!isDirectory || "".equals(path) || path.endsWith("/")) {
            return new URL(url);
        }
        return new URL(url + "/");
    }

    void setCredentials(String username, String password) {
        this.username = username;
        this.password = password;
        if (this.log == null) {
            this.log = new StderrLogService();
            this.log.setLevel(4);
            this.debug = true;
        }
        this.provider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
    }

    void setBaseUrl(String url) {
        this.baseURL = url;
        if (!this.baseURL.endsWith("/")) {
            this.baseURL = this.baseURL + "/";
        }
    }

    static class UnauthenticatedException
    extends Exception {
        UnauthenticatedException() {
        }
    }
}

