/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.AWTEvent;

public abstract class AbstractBlockFilter
implements ExtendedPlugInFilter,
DialogListener {
    protected static int blockRadiusX = 40;
    protected static int blockRadiusY = 40;
    protected int brx;
    protected int bry;
    protected static final int flags = 29;
    protected FloatProcessor[] fps;
    protected ImageProcessor pip = null;

    protected abstract String dialogTitle();

    protected abstract void copyParameters();

    protected abstract void process(int var1);

    protected void init(ImagePlus imp) {
        this.pip = imp.getProcessor();
        if (imp.getType() == 4) {
            int[] rgbs = (int[])this.pip.getPixels();
            float[] rs = new float[rgbs.length];
            float[] gs = new float[rgbs.length];
            float[] bs = new float[rgbs.length];
            for (int i = 0; i < rgbs.length; ++i) {
                int rgb = rgbs[i];
                rs[i] = rgb >> 16 & 0xFF;
                gs[i] = rgb >> 8 & 0xFF;
                bs[i] = rgb & 0xFF;
            }
            FloatProcessor fp0 = new FloatProcessor(imp.getWidth(), imp.getHeight(), rs, null);
            FloatProcessor fp1 = new FloatProcessor(imp.getWidth(), imp.getHeight(), gs, null);
            FloatProcessor fp2 = new FloatProcessor(imp.getWidth(), imp.getHeight(), bs, null);
            fp0.setMinAndMax(this.pip.getMin(), this.pip.getMax());
            fp1.setMinAndMax(this.pip.getMin(), this.pip.getMax());
            fp2.setMinAndMax(this.pip.getMin(), this.pip.getMax());
            this.fps = new FloatProcessor[]{fp0, fp1, fp2};
        } else {
            this.fps = imp.getType() == 2 ? new FloatProcessor[]{(FloatProcessor)this.pip} : new FloatProcessor[]{(FloatProcessor)this.pip.convertToFloat()};
            this.fps[0].setMinAndMax(this.pip.getMin(), this.pip.getMax());
        }
    }

    protected void toRGB(int[] rgbs) {
        float[] rs = (float[])this.fps[0].getPixels();
        float[] gs = (float[])this.fps[1].getPixels();
        float[] bs = (float[])this.fps[2].getPixels();
        for (int i = 0; i < rgbs.length; ++i) {
            int r = Math.max(0, Math.min(255, Math.round(rs[i])));
            int g = Math.max(0, Math.min(255, Math.round(gs[i])));
            int b = Math.max(0, Math.min(255, Math.round(bs[i])));
            rgbs[i] = rgbs[i] & 0xFF000000 | ((r << 8 | g) << 8 | b);
        }
    }

    protected void toByte(byte[] bytes) {
        float[] fs = (float[])this.fps[0].getPixels();
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Math.max(0, Math.min(255, Math.round(fs[i])));
        }
    }

    protected void toShort(short[] shorts) {
        float[] fs = (float[])this.fps[0].getPixels();
        for (int i = 0; i < shorts.length; ++i) {
            shorts[i] = (short)Math.max(0, Math.min(65535, Math.round(fs[i])));
        }
    }

    public int setup(String arg, ImagePlus imp) {
        return 29;
    }

    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        GenericDialog gd = new GenericDialog(this.dialogTitle());
        gd.addNumericField("Block_radius_x : ", (double)blockRadiusX, 0, 6, "pixels");
        gd.addNumericField("Block_radius_y : ", (double)blockRadiusY, 0, 6, "pixels");
        gd.addPreviewCheckbox(pfr);
        gd.addDialogListener((DialogListener)this);
        this.init(imp);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 4096;
        }
        IJ.register(this.getClass());
        return IJ.setupDialog((ImagePlus)imp, (int)29);
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        blockRadiusX = (int)gd.getNextNumber();
        blockRadiusY = (int)gd.getNextNumber();
        return !gd.invalidNumber();
    }

    public void run(ImageProcessor ip) {
        this.init(new ImagePlus("", ip));
        this.copyParameters();
        for (int i = 0; i < this.fps.length; ++i) {
            this.process(i);
        }
        if (FloatProcessor.class.isInstance(ip)) {
            return;
        }
        if (ColorProcessor.class.isInstance(ip)) {
            int[] rgbs = (int[])ip.getPixels();
            this.toRGB(rgbs);
        } else if (ByteProcessor.class.isInstance(ip)) {
            byte[] bytes = (byte[])ip.getPixels();
            this.toByte(bytes);
        } else if (ShortProcessor.class.isInstance(ip)) {
            short[] shorts = (short[])ip.getPixels();
            this.toShort(shorts);
        }
    }

    public void setNPasses(int nPasses) {
    }
}

