/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo;

import java.util.Date;
import org.ojalgo.machine.Hardware;
import org.ojalgo.machine.VirtualMachine;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.type.StandardType;

public abstract class OjAlgoUtils {
    public static VirtualMachine ENVIRONMENT = null;

    public static String getDate() {
        String tmpManifestValue = OjAlgoUtils.class.getPackage().getSpecificationVersion();
        return tmpManifestValue != null ? tmpManifestValue : StandardType.SQL_DATE.format(new Date());
    }

    public static String getTitle() {
        String tmpManifestValue = OjAlgoUtils.class.getPackage().getImplementationTitle();
        return tmpManifestValue != null ? tmpManifestValue : "ojAlgo";
    }

    public static String getVendor() {
        String tmpManifestValue = OjAlgoUtils.class.getPackage().getImplementationVendor();
        return tmpManifestValue != null ? tmpManifestValue : "Optimatika";
    }

    public static String getVersion() {
        String tmpManifestValue = OjAlgoUtils.class.getPackage().getImplementationVersion();
        return tmpManifestValue != null ? tmpManifestValue : "X.X";
    }

    private OjAlgoUtils() {
    }

    static {
        String tmpArchitecture = VirtualMachine.getArchitecture();
        long tmpMemory = VirtualMachine.getMemory();
        int tmpThreads = VirtualMachine.getThreads();
        for (Hardware hw : Hardware.PREDEFINED) {
            if (!hw.architecture.equals(tmpArchitecture) || hw.threads > tmpThreads || hw.memory < tmpMemory) continue;
            ENVIRONMENT = hw.virtualise();
        }
        if (ENVIRONMENT == null) {
            if (System.getProperty("shut.up.ojAlgo") == null) {
                BasicLogger.debug("ojAlgo includes a small set of predefined hardware profiles,");
                BasicLogger.debug("none of which were deemed suitable for the hardware you're currently using.");
                BasicLogger.debug("A default hardware profile, that is perfectly usable, has been set for you.");
                BasicLogger.debug("You may want to set org.ojalgo.OjAlgoUtils.ENVIRONMENT to something that");
                BasicLogger.debug("better matches the hardware/OS/JVM you're running on, than the default.");
                BasicLogger.debug("Additionally it would be appreciated if you contribute your hardware profile.");
                BasicLogger.debug("https://lists.sourceforge.net/lists/listinfo/ojalgo-user");
                BasicLogger.debug("https://github.com/optimatika/ojAlgo/issues");
                BasicLogger.debug("Architecture={} Threads={} Memory={}", tmpArchitecture, tmpThreads, tmpMemory);
            }
            ENVIRONMENT = Hardware.makeSimple(tmpArchitecture, tmpMemory, tmpThreads).virtualise();
        }
    }
}

