/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.util.RandomAccess;
import org.ojalgo.access.Access1D;
import org.ojalgo.array.DenseArray;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.ParameterFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;

abstract class PlainArray<N extends Number>
extends DenseArray<N>
implements RandomAccess {
    static final int CHARACTERISTICS = 1040;

    PlainArray(DenseArray.Factory<N> factory, int size) {
        super(factory);
        if (size > 0x7FFFFFF7) {
            throw new IllegalArgumentException("Array too large!");
        }
    }

    @Override
    public void add(long index, double addend) {
        this.add((int)index, addend);
    }

    @Override
    public void add(long index, Number addend) {
        this.add((int)index, addend);
    }

    @Override
    public final long count() {
        return this.size();
    }

    @Override
    public final double doubleValue(long index) {
        return this.doubleValue((int)index);
    }

    @Override
    public final void fillAll(N number) {
        this.fill(0, this.size(), 1, number);
    }

    @Override
    public final void fillAll(NullaryFunction<N> supplier) {
        this.fill(0, this.size(), 1, supplier);
    }

    @Override
    public final void fillOne(long index, Access1D<?> values, long valueIndex) {
        this.fillOne((int)index, values, valueIndex);
    }

    @Override
    public void fillOne(long index, N value) {
        this.fillOne((int)index, value);
    }

    @Override
    public void fillOne(long index, NullaryFunction<N> supplier) {
        this.fillOne((int)index, supplier);
    }

    @Override
    public final void fillRange(long first, long limit, N number) {
        this.fill(first, limit, 1L, number);
    }

    @Override
    public final void fillRange(long first, long limit, NullaryFunction<N> supplier) {
        this.fill(first, limit, 1L, supplier);
    }

    @Override
    public final N get(long index) {
        return this.get((int)index);
    }

    @Override
    public final boolean isAbsolute(long index) {
        return this.isAbsolute((int)index);
    }

    @Override
    public final boolean isSmall(long index, double comparedTo) {
        return this.isSmall((int)index, comparedTo);
    }

    @Override
    public final void modifyOne(long index, UnaryFunction<N> modifier) {
        this.modifyOne((int)index, modifier);
    }

    @Override
    public final void set(long index, double value) {
        this.set((int)index, value);
    }

    @Override
    public final void set(long index, Number number) {
        this.set((int)index, number);
    }

    @Override
    public void visitOne(long index, VoidFunction<N> visitor) {
        this.visitOne((int)index, visitor);
    }

    private final boolean isSmall(int first, int limit, int step, double comparedTo) {
        boolean retVal = true;
        for (int i = first; retVal && i < limit; retVal &= this.isSmall(i, comparedTo), i += step) {
        }
        return retVal;
    }

    protected abstract void add(int var1, double var2);

    protected abstract void add(int var1, Number var2);

    protected abstract double doubleValue(int var1);

    protected abstract void exchange(int var1, int var2, int var3, int var4);

    @Override
    protected final void exchange(long firstA, long firstB, long step, long count) {
        this.exchange((int)firstA, (int)firstB, (int)step, (int)count);
    }

    protected abstract void fill(int var1, int var2, Access1D<N> var3, BinaryFunction<N> var4, Access1D<N> var5);

    protected abstract void fill(int var1, int var2, Access1D<N> var3, BinaryFunction<N> var4, N var5);

    protected abstract void fill(int var1, int var2, int var3, N var4);

    protected abstract void fill(int var1, int var2, int var3, NullaryFunction<N> var4);

    protected abstract void fill(int var1, int var2, N var3, BinaryFunction<N> var4, Access1D<N> var5);

    @Override
    protected final void fill(long first, long limit, long step, N value) {
        this.fill((int)first, (int)limit, (int)step, value);
    }

    @Override
    protected final void fill(long first, long limit, long step, NullaryFunction<N> supplier) {
        this.fill((int)first, (int)limit, (int)step, supplier);
    }

    protected abstract void fillOne(int var1, Access1D<?> var2, long var3);

    protected abstract void fillOne(int var1, N var2);

    protected abstract void fillOne(int var1, NullaryFunction<N> var2);

    protected abstract N get(int var1);

    protected abstract int indexOfLargest(int var1, int var2, int var3);

    @Override
    protected final long indexOfLargest(long first, long limit, long step) {
        return this.indexOfLargest((int)first, (int)limit, (int)step);
    }

    protected abstract boolean isAbsolute(int var1);

    protected abstract boolean isSmall(int var1, double var2);

    @Override
    protected final boolean isSmall(long first, long limit, long step, double comparedTo) {
        return this.isSmall((int)first, (int)limit, (int)step, comparedTo);
    }

    protected abstract void modify(int var1, int var2, int var3, Access1D<N> var4, BinaryFunction<N> var5);

    protected abstract void modify(int var1, int var2, int var3, BinaryFunction<N> var4, Access1D<N> var5);

    protected abstract void modify(int var1, int var2, int var3, BinaryFunction<N> var4, N var5);

    protected abstract void modify(int var1, int var2, int var3, N var4, BinaryFunction<N> var5);

    protected abstract void modify(int var1, int var2, int var3, ParameterFunction<N> var4, int var5);

    protected abstract void modify(int var1, int var2, int var3, UnaryFunction<N> var4);

    @Override
    protected final void modify(long first, long limit, long step, Access1D<N> left, BinaryFunction<N> function) {
        this.modify((int)first, (int)limit, (int)step, (N)left, function);
    }

    @Override
    protected final void modify(long first, long limit, long step, BinaryFunction<N> function, Access1D<N> right) {
        this.modify((int)first, (int)limit, (int)step, function, (N)right);
    }

    @Override
    protected final void modify(long first, long limit, long step, UnaryFunction<N> function) {
        this.modify((int)first, (int)limit, (int)step, function);
    }

    protected abstract void modifyOne(int var1, UnaryFunction<N> var2);

    protected abstract int searchAscending(N var1);

    protected abstract void set(int var1, double var2);

    protected abstract void set(int var1, Number var2);

    protected abstract int size();

    protected abstract void sortAscending();

    protected abstract void sortDescending();

    protected abstract void visit(int var1, int var2, int var3, VoidFunction<N> var4);

    @Override
    protected final void visit(long first, long limit, long step, VoidFunction<N> visitor) {
        this.visit((int)first, (int)limit, (int)step, visitor);
    }

    protected abstract void visitOne(int var1, VoidFunction<N> var2);
}

