/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.Hessenberg;
import org.ojalgo.matrix.decomposition.InPlaceDecomposition;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.GenericDenseStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.matrix.transformation.HouseholderReference;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;

abstract class HessenbergDecomposition<N extends Number>
extends InPlaceDecomposition<N>
implements Hessenberg<N> {
    private transient DecompositionStore<N> myQ = null;
    private boolean myUpper = true;

    protected HessenbergDecomposition(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> aFactory) {
        super(aFactory);
    }

    @Override
    public final boolean compute(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix, boolean upper) {
        this.reset();
        this.myUpper = upper;
        DecompositionStore tmpStore = this.setInPlace(matrix);
        int tmpRowDim = this.getRowDim();
        int tmpColDim = this.getColDim();
        if (upper) {
            Householder tmpHouseholderCol = this.makeHouseholder(tmpRowDim);
            int tmpLimit = Math.min(tmpRowDim, tmpColDim) - 2;
            for (int ij = 0; ij < tmpLimit; ++ij) {
                if (!tmpStore.generateApplyAndCopyHouseholderColumn(ij + 1, ij, tmpHouseholderCol)) continue;
                tmpStore.transformLeft(tmpHouseholderCol, ij + 1);
                tmpStore.transformRight(tmpHouseholderCol, 0);
            }
        } else {
            Householder tmpHouseholderRow = this.makeHouseholder(tmpColDim);
            int tmpLimit = Math.min(tmpRowDim, tmpColDim) - 2;
            for (int ij = 0; ij < tmpLimit; ++ij) {
                if (!tmpStore.generateApplyAndCopyHouseholderRow(ij, ij + 1, tmpHouseholderRow)) continue;
                tmpStore.transformRight(tmpHouseholderRow, ij + 1);
                tmpStore.transformLeft(tmpHouseholderRow, 0);
            }
        }
        return this.computed(true);
    }

    @Override
    public final boolean decompose(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix) {
        return this.compute(matrix, true);
    }

    @Override
    public final MatrixStore<N> getH() {
        return this.getInPlace().logical().hessenberg(this.myUpper).get();
    }

    @Override
    public final MatrixStore<N> getQ() {
        if (this.myQ == null) {
            this.myQ = this.makeQ(this.makeEye(this.getRowDim(), this.getColDim()), this.myUpper, true);
        }
        return this.myQ;
    }

    @Override
    public boolean isUpper() {
        return this.myUpper;
    }

    @Override
    public void reset() {
        super.reset();
        this.myQ = null;
        this.myUpper = true;
    }

    private final DecompositionStore<N> makeQ(DecompositionStore<N> storeToTransform, boolean upper, boolean eye) {
        int tmpRowAndColDim = (int)storeToTransform.countRows();
        HouseholderReference tmpReference = HouseholderReference.make(this.getInPlace(), upper);
        for (int ij = tmpRowAndColDim - 3; ij >= 0; --ij) {
            tmpReference.point(upper ? (long)(ij + 1) : (long)ij, upper ? (long)ij : (long)(ij + 1));
            if (tmpReference.isZero()) continue;
            storeToTransform.transformLeft(tmpReference, eye ? ij : 0);
        }
        return storeToTransform;
    }

    final DecompositionStore<N> doQ(DecompositionStore<N> aStoreToTransform) {
        return this.makeQ(aStoreToTransform, this.myUpper, false);
    }

    static final class Rational
    extends HessenbergDecomposition<RationalNumber> {
        Rational() {
            super(GenericDenseStore.RATIONAL);
        }
    }

    static final class Quat
    extends HessenbergDecomposition<Quaternion> {
        Quat() {
            super(GenericDenseStore.QUATERNION);
        }
    }

    static final class Primitive
    extends HessenbergDecomposition<Double> {
        Primitive() {
            super(PrimitiveDenseStore.FACTORY);
        }
    }

    static final class Complex
    extends HessenbergDecomposition<ComplexNumber> {
        Complex() {
            super(GenericDenseStore.COMPLEX);
        }
    }

    static final class Big
    extends HessenbergDecomposition<BigDecimal> {
        Big() {
            super(BigDenseStore.FACTORY);
        }
    }
}

