/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.geometry;

import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.geometry.GeometryMatrix;
import org.ojalgo.matrix.geometry.Primitive32Vector2;
import org.ojalgo.matrix.transformation.TransformationMatrix;

public class Primitive32Matrix2
implements GeometryMatrix<Primitive32Matrix2>,
TransformationMatrix<Double, Primitive32Vector2> {
    public float m00;
    public float m10;
    public float m01;
    public float m11;

    public Primitive32Matrix2() {
    }

    public Primitive32Matrix2(float m00, float m10, float m01, float m11) {
        this.m00 = m00;
        this.m10 = m10;
        this.m01 = m01;
        this.m11 = m11;
    }

    @Override
    public final long countColumns() {
        return 2L;
    }

    @Override
    public final long countRows() {
        return 2L;
    }

    @Override
    public final double doubleValue(int row, int col) {
        switch (col) {
            case 0: {
                switch (row) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m10;
                    }
                }
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return this.m01;
                    }
                    case 1: {
                        return this.m11;
                    }
                }
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Primitive32Matrix2)) {
            return false;
        }
        Primitive32Matrix2 other = (Primitive32Matrix2)obj;
        if (Float.floatToIntBits(this.m00) != Float.floatToIntBits(other.m00)) {
            return false;
        }
        if (Float.floatToIntBits(this.m01) != Float.floatToIntBits(other.m01)) {
            return false;
        }
        if (Float.floatToIntBits(this.m10) != Float.floatToIntBits(other.m10)) {
            return false;
        }
        return Float.floatToIntBits(this.m11) == Float.floatToIntBits(other.m11);
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.m00);
        result = 31 * result + Float.floatToIntBits(this.m01);
        result = 31 * result + Float.floatToIntBits(this.m10);
        result = 31 * result + Float.floatToIntBits(this.m11);
        return result;
    }

    public final void multiply(Primitive32Vector2 right, Primitive32Vector2 product) {
        float right0 = right.v0;
        float right1 = right.v1;
        product.v0 = this.m00 * right0 + this.m01 * right1;
        product.v1 = this.m10 * right0 + this.m11 * right1;
    }

    @Override
    public final void negate(Primitive32Matrix2 matrix) {
        this.m00 = -matrix.m00;
        this.m01 = -matrix.m01;
        this.m10 = -matrix.m10;
        this.m11 = -matrix.m11;
    }

    public final String toString() {
        return Access2D.toString(this);
    }

    @Override
    public final void transform(Primitive32Vector2 transformable) {
        this.multiply(transformable, transformable);
    }

    @Override
    public final void transpose(Primitive32Matrix2 matrix) {
        this.m00 = matrix.m00;
        this.m01 = matrix.m10;
        this.m10 = matrix.m01;
        this.m11 = matrix.m11;
    }
}

