/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.geometry;

import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.geometry.GeometryMatrix;
import org.ojalgo.matrix.geometry.Primitive32Vector2;
import org.ojalgo.matrix.geometry.Primitive32Vector3;
import org.ojalgo.matrix.transformation.TransformationMatrix;

public class Primitive32Matrix3
implements GeometryMatrix<Primitive32Matrix3>,
TransformationMatrix<Double, Primitive32Vector3> {
    public float m00;
    public float m10;
    public float m20;
    public float m01;
    public float m11;
    public float m21;
    public float m02;
    public float m12;
    public float m22;

    public Primitive32Matrix3() {
    }

    public Primitive32Matrix3(float m00, float m10, float m20, float m01, float m11, float m21, float m02, float m12, float m22) {
        this.m00 = m00;
        this.m10 = m10;
        this.m20 = m20;
        this.m01 = m01;
        this.m11 = m11;
        this.m21 = m21;
        this.m02 = m02;
        this.m12 = m12;
        this.m22 = m22;
    }

    @Override
    public final long countColumns() {
        return 3L;
    }

    @Override
    public final long countRows() {
        return 3L;
    }

    @Override
    public final double doubleValue(int row, int col) {
        switch (col) {
            case 0: {
                switch (row) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m10;
                    }
                    case 2: {
                        return this.m20;
                    }
                }
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return this.m01;
                    }
                    case 1: {
                        return this.m11;
                    }
                    case 2: {
                        return this.m21;
                    }
                }
            }
            case 2: {
                switch (row) {
                    case 0: {
                        return this.m02;
                    }
                    case 1: {
                        return this.m12;
                    }
                    case 2: {
                        return this.m22;
                    }
                }
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Primitive32Matrix3)) {
            return false;
        }
        Primitive32Matrix3 other = (Primitive32Matrix3)obj;
        if (Float.floatToIntBits(this.m00) != Float.floatToIntBits(other.m00)) {
            return false;
        }
        if (Float.floatToIntBits(this.m01) != Float.floatToIntBits(other.m01)) {
            return false;
        }
        if (Float.floatToIntBits(this.m02) != Float.floatToIntBits(other.m02)) {
            return false;
        }
        if (Float.floatToIntBits(this.m10) != Float.floatToIntBits(other.m10)) {
            return false;
        }
        if (Float.floatToIntBits(this.m11) != Float.floatToIntBits(other.m11)) {
            return false;
        }
        if (Float.floatToIntBits(this.m12) != Float.floatToIntBits(other.m12)) {
            return false;
        }
        if (Float.floatToIntBits(this.m20) != Float.floatToIntBits(other.m20)) {
            return false;
        }
        if (Float.floatToIntBits(this.m21) != Float.floatToIntBits(other.m21)) {
            return false;
        }
        return Float.floatToIntBits(this.m22) == Float.floatToIntBits(other.m22);
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.m00);
        result = 31 * result + Float.floatToIntBits(this.m01);
        result = 31 * result + Float.floatToIntBits(this.m02);
        result = 31 * result + Float.floatToIntBits(this.m10);
        result = 31 * result + Float.floatToIntBits(this.m11);
        result = 31 * result + Float.floatToIntBits(this.m12);
        result = 31 * result + Float.floatToIntBits(this.m20);
        result = 31 * result + Float.floatToIntBits(this.m21);
        result = 31 * result + Float.floatToIntBits(this.m22);
        return result;
    }

    public final void multiply(Primitive32Vector2 right, float right2, Primitive32Vector2 product) {
        float right0 = right.v0;
        float right1 = right.v1;
        product.v0 = this.m00 * right0 + this.m01 * right1 + this.m02 * right2;
        product.v1 = this.m10 * right0 + this.m11 * right1 + this.m12 * right2;
    }

    public final void multiply(Primitive32Vector3 right, Primitive32Vector3 product) {
        float right0 = right.v0;
        float right1 = right.v1;
        float right2 = right.v2;
        product.v0 = this.m00 * right0 + this.m01 * right1 + this.m02 * right2;
        product.v1 = this.m10 * right0 + this.m11 * right1 + this.m12 * right2;
        product.v2 = this.m20 * right0 + this.m21 * right1 + this.m22 * right2;
    }

    @Override
    public final void negate(Primitive32Matrix3 matrix) {
        this.m00 = -matrix.m00;
        this.m01 = -matrix.m01;
        this.m02 = -matrix.m02;
        this.m10 = -matrix.m10;
        this.m11 = -matrix.m11;
        this.m12 = -matrix.m12;
        this.m20 = -matrix.m20;
        this.m21 = -matrix.m21;
        this.m22 = -matrix.m22;
    }

    public final String toString() {
        return Access2D.toString(this);
    }

    public final void transform(Primitive32Vector2 transformable, float v2) {
        this.multiply(transformable, v2, transformable);
    }

    @Override
    public final void transform(Primitive32Vector3 transformable) {
        this.multiply(transformable, transformable);
    }

    @Override
    public final void transpose(Primitive32Matrix3 matrix) {
        this.m00 = matrix.m00;
        this.m01 = matrix.m10;
        this.m02 = matrix.m20;
        this.m10 = matrix.m01;
        this.m11 = matrix.m11;
        this.m12 = matrix.m21;
        this.m20 = matrix.m02;
        this.m21 = matrix.m12;
        this.m22 = matrix.m22;
    }
}

