/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.geometry;

import org.ojalgo.function.UnaryFunction;
import org.ojalgo.matrix.geometry.GeometryVector;
import org.ojalgo.matrix.store.operation.MultiplyBoth;

public class Primitive32Vector2
extends GeometryVector {
    public float v0;
    public float v1;

    public Primitive32Vector2() {
        super(MultiplyBoth.getPrimitive(2L, 1L), 2L, 1L);
    }

    public Primitive32Vector2(float v0, float v1) {
        this();
        this.v0 = v0;
        this.v1 = v1;
    }

    @Override
    public final void add(int row, double addend) {
        switch (row) {
            case 0: {
                this.v0 = (float)((double)this.v0 + addend);
                break;
            }
            case 1: {
                this.v1 = (float)((double)this.v1 + addend);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public final long count() {
        return 2L;
    }

    @Override
    public final double doubleValue(int index) {
        switch (index) {
            case 0: {
                return this.v0;
            }
            case 1: {
                return this.v1;
            }
        }
        throw new IllegalArgumentException();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Primitive32Vector2)) {
            return false;
        }
        Primitive32Vector2 other = (Primitive32Vector2)obj;
        if (Float.floatToIntBits(this.v0) != Float.floatToIntBits(other.v0)) {
            return false;
        }
        return Float.floatToIntBits(this.v1) == Float.floatToIntBits(other.v1);
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.v0);
        result = 31 * result + Float.floatToIntBits(this.v1);
        return result;
    }

    @Override
    public final void modifyOne(int row, UnaryFunction<Double> modifier) {
        switch (row) {
            case 0: {
                this.v0 = (float)modifier.invoke(this.v0);
                break;
            }
            case 1: {
                this.v1 = (float)modifier.invoke(this.v1);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public final void set(int row, double value) {
        switch (row) {
            case 0: {
                this.v0 = (float)value;
                break;
            }
            case 1: {
                this.v1 = (float)value;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }
}

