/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.algebra.ScalarOperation;
import org.ojalgo.function.BigFunction;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.scalar.Scalar;

public final class RotateLeft
extends MatrixOperation {
    public static final RotateLeft SETUP = new RotateLeft();
    public static int THRESHOLD = 128;

    public static void invoke(BigDecimal[] data, int structure, int rowA, int rowB, BigDecimal cos, BigDecimal sin) {
        int indexA = rowA;
        int indexB = rowB;
        int lim = data.length / structure;
        for (int j = 0; j < lim; ++j) {
            BigDecimal oldA = data[indexA];
            BigDecimal oldB = data[indexB];
            data[indexA] = BigFunction.ADD.invoke(BigFunction.MULTIPLY.invoke(cos, oldA), BigFunction.MULTIPLY.invoke(sin, oldB));
            data[indexB] = BigFunction.SUBTRACT.invoke(BigFunction.MULTIPLY.invoke(cos, oldB), BigFunction.MULTIPLY.invoke(sin, oldA));
            indexA += structure;
            indexB += structure;
        }
    }

    public static void invoke(double[] data, int structure, int rowA, int rowB, double cos, double sin) {
        int indexA = rowA;
        int indexB = rowB;
        int lim = data.length / structure;
        for (int j = 0; j < lim; ++j) {
            double oldA = data[indexA];
            double oldB = data[indexB];
            data[indexA] = cos * oldA + sin * oldB;
            data[indexB] = cos * oldB - sin * oldA;
            indexA += structure;
            indexB += structure;
        }
    }

    public static <N extends Number> void invoke(N[] data, int structure, int rowA, int rowB, N cos, N sin) {
        int indexA = rowA;
        int indexB = rowB;
        int lim = data.length / structure;
        for (int j = 0; j < lim; ++j) {
            N oldA = data[indexA];
            N oldB = data[indexB];
            data[indexA] = ((Scalar)((ScalarOperation.Multiplication)((Object)cos)).multiply(oldA)).add((Scalar)((ScalarOperation.Multiplication)((Object)sin)).multiply(oldB)).get();
            data[indexB] = ((Scalar)((ScalarOperation.Multiplication)((Object)cos)).multiply(oldB)).subtract((Scalar)((ScalarOperation.Multiplication)((Object)sin)).multiply(oldA)).get();
            indexA += structure;
            indexB += structure;
        }
    }

    private RotateLeft() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

