/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure1D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.SparseArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.PrimitiveMatrix;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.store.RowsSupplier;
import org.ojalgo.matrix.store.SparseStore;
import org.ojalgo.optimisation.Expression;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.GenericSolver;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.optimisation.convex.IterativeASS;
import org.ojalgo.optimisation.convex.QPESolver;
import org.ojalgo.optimisation.convex.UnconstrainedSolver;
import org.ojalgo.optimisation.linear.LinearSolver;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.type.context.NumberContext;

public abstract class ConvexSolver
extends GenericSolver {
    static final PhysicalStore.Factory<Double, PrimitiveDenseStore> FACTORY = PrimitiveDenseStore.FACTORY;
    private final Builder myMatrices;
    private final PrimitiveDenseStore mySolutionX;
    private final LU<Double> mySolverGeneral;
    private final Cholesky<Double> mySolverQ;

    public static void copy(ExpressionsBasedModel sourceModel, Builder destinationBuilder) {
        destinationBuilder.reset();
        List<Variable> freeVariables = sourceModel.getFreeVariables();
        Set<Structure1D.IntIndex> fixedVariables = sourceModel.getFixedVariables();
        int numbVars = freeVariables.size();
        List tmpEqExpr = sourceModel.constraints().filter(c -> c.isEqualityConstraint() && !c.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
        int numbEqExpr = tmpEqExpr.size();
        if (numbEqExpr > 0) {
            SparseStore<Double> mtrxAE = SparseStore.PRIMITIVE.make(numbEqExpr, numbVars);
            PhysicalStore mtrxBE = (PhysicalStore)FACTORY.makeZero(numbEqExpr, 1L);
            for (int i = 0; i < numbEqExpr; ++i) {
                Expression tmpExpression = ((Expression)tmpEqExpr.get(i)).compensate(fixedVariables);
                for (Structure1D.IntIndex intIndex : tmpExpression.getLinearKeySet()) {
                    int tmpIndex = sourceModel.indexOfFreeVariable(intIndex.index);
                    if (tmpIndex < 0) continue;
                    mtrxAE.set((long)i, (long)tmpIndex, tmpExpression.getAdjustedLinearFactor(intIndex));
                }
                mtrxBE.set((long)i, 0L, tmpExpression.getAdjustedUpperLimit());
            }
            destinationBuilder.equalities(mtrxAE, mtrxBE);
        }
        Expression tmpObjExpr = sourceModel.objective().compensate(fixedVariables);
        PhysicalStore mtrxQ = null;
        if (tmpObjExpr.isAnyQuadraticFactorNonZero()) {
            mtrxQ = (PhysicalStore)FACTORY.makeZero(numbVars, numbVars);
            PrimitiveFunction.Binary tmpBaseFunc = sourceModel.isMaximisation() ? PrimitiveFunction.SUBTRACT : PrimitiveFunction.ADD;
            for (Structure2D.IntRowColumn intRowColumn : tmpObjExpr.getQuadraticKeySet()) {
                int tmpRow = sourceModel.indexOfFreeVariable(intRowColumn.row);
                int tmpColumn = sourceModel.indexOfFreeVariable(intRowColumn.column);
                if (tmpRow < 0 || tmpColumn < 0) continue;
                UnaryFunction<double> tmpModifier = tmpBaseFunc.second(tmpObjExpr.getAdjustedQuadraticFactor(intRowColumn));
                mtrxQ.modifyOne(tmpRow, tmpColumn, tmpModifier);
                mtrxQ.modifyOne(tmpColumn, tmpRow, tmpModifier);
            }
        }
        PhysicalStore mtrxC = null;
        if (tmpObjExpr.isAnyLinearFactorNonZero()) {
            mtrxC = (PhysicalStore)FACTORY.makeZero(numbVars, 1L);
            if (sourceModel.isMinimisation()) {
                for (Structure1D.IntIndex tmpKey : tmpObjExpr.getLinearKeySet()) {
                    int n = sourceModel.indexOfFreeVariable(tmpKey.index);
                    if (n < 0) continue;
                    mtrxC.set((long)n, 0L, -tmpObjExpr.getAdjustedLinearFactor(tmpKey));
                }
            } else {
                for (Structure1D.IntIndex tmpKey : tmpObjExpr.getLinearKeySet()) {
                    int n = sourceModel.indexOfFreeVariable(tmpKey.index);
                    if (n < 0) continue;
                    mtrxC.set((long)n, 0L, tmpObjExpr.getAdjustedLinearFactor(tmpKey));
                }
            }
        }
        destinationBuilder.objective(mtrxQ, mtrxC);
        List tmpUpExpr = sourceModel.constraints().filter(e -> e.isUpperConstraint() && !e.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
        int numbUpExpr = tmpUpExpr.size();
        List list = sourceModel.bounds().filter(c4 -> c4.isUpperConstraint()).collect(Collectors.toList());
        int numbUpVar = list.size();
        List tmpLoExpr = sourceModel.constraints().filter(c1 -> c1.isLowerConstraint() && !c1.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
        int numbLoExpr = tmpLoExpr.size();
        List tmpLoVar = sourceModel.bounds().filter(c3 -> c3.isLowerConstraint()).collect(Collectors.toList());
        int numbLoVar = tmpLoVar.size();
        if (numbUpExpr + numbUpVar + numbLoExpr + numbLoVar > 0) {
            Variable tmpVariable;
            int tmpIndex;
            Expression tmpExpression;
            SparseArray<Double> rowAI;
            int i;
            RowsSupplier<Double> mtrxAI = FACTORY.makeRowsSupplier(numbVars);
            PhysicalStore mtrxBI = (PhysicalStore)FACTORY.makeZero(numbUpExpr + numbUpVar + numbLoExpr + numbLoVar, 1L);
            if (numbUpExpr > 0) {
                for (i = 0; i < numbUpExpr; ++i) {
                    rowAI = mtrxAI.addRow();
                    tmpExpression = ((Expression)tmpUpExpr.get(i)).compensate(fixedVariables);
                    for (Structure1D.IntIndex tmpKey : tmpExpression.getLinearKeySet()) {
                        tmpIndex = sourceModel.indexOfFreeVariable(tmpKey.index);
                        if (tmpIndex < 0) continue;
                        rowAI.set((long)tmpIndex, tmpExpression.getAdjustedLinearFactor(tmpKey));
                    }
                    mtrxBI.set((long)i, 0L, tmpExpression.getAdjustedUpperLimit());
                }
            }
            if (numbUpVar > 0) {
                for (i = 0; i < numbUpVar; ++i) {
                    rowAI = mtrxAI.addRow();
                    tmpVariable = (Variable)list.get(i);
                    rowAI.set((long)sourceModel.indexOfFreeVariable(tmpVariable), tmpVariable.getAdjustmentFactor());
                    mtrxBI.set((long)(numbUpExpr + i), 0L, tmpVariable.getAdjustedUpperLimit());
                }
            }
            if (numbLoExpr > 0) {
                for (i = 0; i < numbLoExpr; ++i) {
                    rowAI = mtrxAI.addRow();
                    tmpExpression = ((Expression)tmpLoExpr.get(i)).compensate(fixedVariables);
                    for (Structure1D.IntIndex tmpKey : tmpExpression.getLinearKeySet()) {
                        tmpIndex = sourceModel.indexOfFreeVariable(tmpKey.index);
                        if (tmpIndex < 0) continue;
                        rowAI.set((long)tmpIndex, -tmpExpression.getAdjustedLinearFactor(tmpKey));
                    }
                    mtrxBI.set((long)(numbUpExpr + numbUpVar + i), 0L, -tmpExpression.getAdjustedLowerLimit());
                }
            }
            if (numbLoVar > 0) {
                for (i = 0; i < numbLoVar; ++i) {
                    rowAI = mtrxAI.addRow();
                    tmpVariable = (Variable)tmpLoVar.get(i);
                    rowAI.set((long)sourceModel.indexOfFreeVariable(tmpVariable), -tmpVariable.getAdjustmentFactor());
                    mtrxBI.set((long)(numbUpExpr + numbUpVar + numbLoExpr + i), 0L, -tmpVariable.getAdjustedLowerLimit());
                }
            }
            destinationBuilder.inequalities(mtrxAI, mtrxBI);
        }
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public static Builder getBuilder(MatrixStore<Double> Q, MatrixStore<Double> C) {
        return ConvexSolver.getBuilder().objective(Q, C);
    }

    private ConvexSolver(Optimisation.Options solverOptions) {
        this(null, solverOptions);
    }

    protected ConvexSolver(Builder matrices, Optimisation.Options solverOptions) {
        super(solverOptions);
        this.myMatrices = matrices;
        this.mySolutionX = (PrimitiveDenseStore)FACTORY.makeZero(this.countVariables(), 1L);
        this.mySolverQ = Cholesky.make(this.getMatrixQ());
        this.mySolverGeneral = LU.make(this.getMatrixQ());
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myMatrices.reset();
    }

    @Override
    public final Optimisation.Result solve(Optimisation.Result kickStarter) {
        boolean ok = true;
        if (this.options.validate) {
            ok = this.validate();
        }
        if (ok) {
            ok = this.initialise(kickStarter);
        }
        if (ok) {
            this.resetIterationsCount();
            do {
                this.performIteration();
                this.incrementIterationsCount();
            } while (!this.getState().isFailure() && this.needsAnotherIteration() && this.isIterationAllowed());
        }
        return this.buildResult();
    }

    public String toString() {
        return this.myMatrices.toString();
    }

    protected boolean computeGeneral(Access2D.Collectable<Double, ? super PhysicalStore<Double>> matrix) {
        return this.mySolverGeneral.compute(matrix);
    }

    protected boolean computeQ(Access2D.Collectable<Double, ? super PhysicalStore<Double>> matrix) {
        return this.mySolverQ.compute(matrix);
    }

    protected int countEqualityConstraints() {
        return this.myMatrices.countEqualityConstraints();
    }

    protected int countInequalityConstraints() {
        return this.myMatrices.countInequalityConstraints();
    }

    protected int countVariables() {
        return this.myMatrices.countVariables();
    }

    @Override
    protected double evaluateFunction(Access1D<?> solution) {
        PhysicalStore<Double> tmpX = this.getSolutionX();
        return tmpX.transpose().multiply(this.getMatrixQ().multiply((Double)((Object)tmpX))).multiply(0.5).subtract(tmpX.transpose().multiply(this.getMatrixC())).doubleValue(0L);
    }

    @Override
    protected MatrixStore<Double> extractSolution() {
        return this.getSolutionX().copy();
    }

    protected abstract Access2D.Collectable<Double, ? super PhysicalStore<Double>> getIterationKKT();

    protected abstract Access2D.Collectable<Double, ? super PhysicalStore<Double>> getIterationRHS();

    protected MatrixStore<Double> getMatrixAE() {
        return this.myMatrices.getAE();
    }

    protected RowsSupplier<Double> getMatrixAI() {
        return this.myMatrices.getAI();
    }

    protected SparseArray<Double> getMatrixAI(int row) {
        return this.myMatrices.getAI().getRow(row);
    }

    protected RowsSupplier<Double> getMatrixAI(int[] rows) {
        return this.myMatrices.getAI().selectRows(rows);
    }

    protected MatrixStore<Double> getMatrixBE() {
        return this.myMatrices.getBE();
    }

    protected MatrixStore<Double> getMatrixBI() {
        return this.myMatrices.getBI();
    }

    protected double getMatrixBI(int row) {
        return this.myMatrices.getBI().doubleValue(row);
    }

    protected MatrixStore<Double> getMatrixBI(int[] selector) {
        return this.myMatrices.getBI().logical().row(selector).get();
    }

    protected MatrixStore<Double> getMatrixC() {
        return this.myMatrices.getC();
    }

    protected PhysicalStore<Double> getMatrixQ() {
        return this.myMatrices.getQ();
    }

    protected int getRankGeneral() {
        return this.mySolverGeneral.getRank();
    }

    protected MatrixStore<Double> getSE() {
        return this.getSolutionX().premultiply(this.getMatrixAE()).operateOnMatching(this.getMatrixBE(), (BinaryFunction<Double>)PrimitiveFunction.SUBTRACT).get();
    }

    protected MatrixStore<Double> getSolutionGeneral(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs) {
        return this.mySolverGeneral.getSolution(rhs);
    }

    protected MatrixStore<Double> getSolutionGeneral(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs, PhysicalStore<Double> preallocated) {
        return this.mySolverGeneral.getSolution(rhs, preallocated);
    }

    protected MatrixStore<Double> getSolutionQ(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs) {
        return this.mySolverQ.getSolution(rhs);
    }

    protected MatrixStore<Double> getSolutionQ(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs, PhysicalStore<Double> preallocated) {
        return this.mySolverQ.getSolution(rhs, preallocated);
    }

    protected PhysicalStore<Double> getSolutionX() {
        return this.mySolutionX;
    }

    protected boolean hasEqualityConstraints() {
        return this.myMatrices.hasEqualityConstraints();
    }

    protected boolean hasInequalityConstraints() {
        return this.myMatrices.hasInequalityConstraints();
    }

    protected boolean hasObjective() {
        return this.myMatrices.hasObjective();
    }

    protected boolean initialise(Optimisation.Result kickStarter) {
        this.computeQ(this.getMatrixQ());
        return true;
    }

    protected boolean isSolvableGeneral() {
        return this.mySolverGeneral.isSolvable();
    }

    protected boolean isSolvableQ() {
        return this.mySolverQ.isSolvable();
    }

    protected abstract boolean needsAnotherIteration();

    protected abstract void performIteration();

    protected boolean solveFullKKT(PhysicalStore<Double> preallocated) {
        if (this.computeGeneral(this.getIterationKKT())) {
            this.getSolutionGeneral(this.getIterationRHS(), preallocated);
            return true;
        }
        if (this.isDebug()) {
            this.options.logger_appender.println("KKT system unsolvable!");
            this.options.logger_appender.printmtrx("KKT", (Access2D)this.getIterationKKT().collect(FACTORY));
            this.options.logger_appender.printmtrx("RHS", (Access2D)this.getIterationRHS().collect(FACTORY));
        }
        return false;
    }

    protected Optimisation.Result solveLP() {
        return LinearSolver.solve(this.myMatrices, this.options);
    }

    protected boolean validate() {
        PhysicalStore<Double> tmpQ = this.getMatrixQ();
        MatrixStore<Double> tmpC = this.getMatrixC();
        if (tmpQ == null || tmpC == null) {
            throw new IllegalArgumentException("Neither Q nor C may be null!");
        }
        if (!MatrixUtils.isHermitian(tmpQ)) {
            if (this.isDebug()) {
                this.log("Q not symmetric!", tmpQ);
            }
            throw new IllegalArgumentException("Q must be symmetric!");
        }
        if (!this.mySolverQ.isSPD()) {
            Eigenvalue<Double> tmpEvD = Eigenvalue.PRIMITIVE.make(true);
            tmpEvD.computeValuesOnly(tmpQ);
            Array1D<ComplexNumber> tmpEigenvalues = tmpEvD.getEigenvalues();
            tmpEvD.reset();
            for (ComplexNumber tmpValue : tmpEigenvalues) {
                if (!(tmpValue.doubleValue() < PrimitiveMath.ZERO) && tmpValue.isReal()) continue;
                if (this.isDebug()) {
                    this.log("Q not positive semidefinite!", new Object[0]);
                    this.log("The eigenvalues are: {}", tmpEigenvalues);
                }
                throw new IllegalArgumentException("Q must be positive semidefinite!");
            }
        }
        this.setState(Optimisation.State.VALID);
        return true;
    }

    void supplySlackI(PhysicalStore<Double> slack) {
        RowsSupplier<Double> mtrxAI = this.myMatrices.getAI();
        MatrixStore<Double> mtrxBI = this.getMatrixBI();
        PhysicalStore<Double> mtrxX = this.getSolutionX();
        slack.fillMatching(mtrxBI);
        int i = 0;
        while ((long)i < mtrxAI.countRows()) {
            slack.add((long)i, -mtrxAI.getRow(i).dot(mtrxX));
            ++i;
        }
    }

    public static final class ModelIntegration
    extends ExpressionsBasedModel.Integration<ConvexSolver> {
        @Override
        public ConvexSolver build(ExpressionsBasedModel model) {
            Builder tmpBuilder = ConvexSolver.getBuilder();
            ConvexSolver.copy(model, tmpBuilder);
            return (ConvexSolver)tmpBuilder.build(model.options);
        }

        @Override
        public boolean isCapable(ExpressionsBasedModel model) {
            return !model.isAnyVariableInteger() && model.isAnyObjectiveQuadratic() && !model.isAnyConstraintQuadratic();
        }

        @Override
        protected boolean isSolutionMapped() {
            return true;
        }
    }

    public static final class Builder
    extends GenericSolver.Builder<Builder, ConvexSolver> {
        private static final NumberContext NC = NumberContext.getGeneral(12);
        private MatrixStore<Double> myAE = null;
        private RowsSupplier<Double> myAI = null;
        private MatrixStore<Double> myBE = null;
        private MatrixStore<Double> myBI = null;
        private MatrixStore<Double> myC = null;
        private PhysicalStore<Double> myQ = null;

        public Builder() {
        }

        public Builder(MatrixStore<Double> C) {
            this.objective(C);
        }

        public Builder(MatrixStore<Double> Q, MatrixStore<Double> C) {
            this.objective(Q, C);
        }

        protected Builder(Builder matrices) {
            if (matrices.hasEqualityConstraints()) {
                this.equalities(matrices.getAE(), matrices.getBE());
            }
            if (matrices.hasObjective()) {
                if (matrices.getQ() != null) {
                    this.objective(matrices.getQ(), matrices.getC());
                } else {
                    this.objective(matrices.getC());
                }
            }
            if (matrices.hasInequalityConstraints()) {
                this.inequalities((Access2D<Double>)matrices.getAI().get(), matrices.getBI());
            }
        }

        Builder(MatrixStore<Double>[] matrices) {
            if (matrices.length >= 2 && matrices[0] != null && matrices[1] != null) {
                this.equalities(matrices[0], matrices[1]);
            }
            if (matrices.length >= 4) {
                if (matrices[2] != null) {
                    this.objective(matrices[2], matrices[3]);
                } else if (matrices[3] != null) {
                    this.objective(matrices[3]);
                }
            }
            if (matrices.length >= 6 && matrices[4] != null && matrices[5] != null) {
                this.inequalities(matrices[4], matrices[5]);
            }
        }

        @Override
        public int countConstraints() {
            return this.countEqualityConstraints() + this.countInequalityConstraints();
        }

        public int countEqualityConstraints() {
            return (int)(this.getAE() != null ? this.getAE().countRows() : 0L);
        }

        public int countInequalityConstraints() {
            return (int)(this.getAI() != null ? this.getAI().countRows() : 0L);
        }

        @Override
        public int countVariables() {
            int retVal = -1;
            if (this.getAE() != null) {
                retVal = (int)this.getAE().countColumns();
            } else if (this.getAI() != null) {
                retVal = (int)this.getAI().countColumns();
            } else if (this.getQ() != null) {
                retVal = (int)this.getQ().countRows();
            } else if (this.getC() != null) {
                retVal = (int)this.getC().countRows();
            } else {
                throw new ProgrammingError("Cannot deduce the number of variables!");
            }
            return retVal;
        }

        public Builder equalities(MatrixStore<Double> mtrxAE, MatrixStore<Double> mtrxBE) {
            ProgrammingError.throwIfNull(mtrxAE, mtrxBE);
            ProgrammingError.throwIfNotEqualRowDimensions(mtrxAE, mtrxBE);
            this.myAE = mtrxAE;
            this.myBE = mtrxBE;
            return this;
        }

        public MatrixStore<Double> getAE() {
            return this.myAE;
        }

        public RowsSupplier<Double> getAI() {
            return this.myAI;
        }

        public SparseArray<Double> getAI(int row) {
            return this.myAI.getRow(row);
        }

        public MatrixStore<Double> getBE() {
            return this.myBE;
        }

        public MatrixStore<Double> getBI() {
            return this.myBI;
        }

        public MatrixStore<Double> getC() {
            return this.myC;
        }

        public PhysicalStore<Double> getQ() {
            return this.myQ;
        }

        public boolean hasEqualityConstraints() {
            return this.myAE != null && this.myAE.countRows() > 0L;
        }

        public boolean hasInequalityConstraints() {
            return this.myAI != null && this.myAI.countRows() > 0L;
        }

        public boolean hasObjective() {
            return this.myQ != null || this.myC != null;
        }

        public Builder inequalities(Access2D<Double> mtrxAI, MatrixStore<Double> mtrxBI) {
            ProgrammingError.throwIfNull(mtrxAI, mtrxBI);
            ProgrammingError.throwIfNotEqualRowDimensions(mtrxAI, mtrxBI);
            if (mtrxAI instanceof RowsSupplier) {
                this.myAI = (RowsSupplier)mtrxAI;
            } else {
                this.myAI = FACTORY.makeRowsSupplier((int)mtrxAI.countColumns());
                this.myAI.addRows((int)mtrxAI.countRows());
                if (mtrxAI instanceof SparseStore) {
                    ((SparseStore)mtrxAI).nonzeros().forEach(nz -> this.myAI.getRow((int)nz.row()).set((long)((int)nz.column()), nz.doubleValue()));
                } else {
                    int i = 0;
                    while ((long)i < mtrxAI.countRows()) {
                        SparseArray<Double> tmpRow = this.myAI.getRow(i);
                        int j = 0;
                        while ((long)j < mtrxAI.countColumns()) {
                            double value = mtrxAI.doubleValue(i, j);
                            if (!NC.isZero(value)) {
                                tmpRow.set((long)j, value);
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            }
            this.myBI = mtrxBI;
            return this;
        }

        public Builder objective(MatrixStore<Double> mtrxC) {
            ProgrammingError.throwIfNull(mtrxC);
            this.myC = mtrxC;
            return this;
        }

        public Builder objective(MatrixStore<Double> mtrxQ, MatrixStore<Double> mtrxC) {
            ProgrammingError.throwIfNull(mtrxQ);
            this.myQ = mtrxQ instanceof PhysicalStore ? (PhysicalStore<Object>)mtrxQ : mtrxQ.copy();
            this.myC = mtrxC != null ? mtrxC : MatrixStore.PRIMITIVE.makeZero((int)mtrxQ.countRows(), 1).get();
            return this;
        }

        public void reset() {
            this.myAE = null;
            this.myAI = null;
            this.myBE = null;
            this.myBI = null;
            this.myC = null;
            this.myQ = null;
        }

        public String toString() {
            String simpleName = this.getClass().getSimpleName();
            StringBuilder retVal = new StringBuilder("<" + simpleName + ">");
            retVal.append("\n[AE] = " + (this.myAE != null ? (Serializable)PrimitiveMatrix.FACTORY.copy(this.getAE()) : "?"));
            retVal.append("\n[BE] = " + (this.myBE != null ? (Serializable)PrimitiveMatrix.FACTORY.copy(this.getBE()) : "?"));
            retVal.append("\n[Q] = " + (this.myQ != null ? (Serializable)PrimitiveMatrix.FACTORY.copy(this.getQ()) : "?"));
            retVal.append("\n[C] = " + (this.myC != null ? (Serializable)PrimitiveMatrix.FACTORY.copy(this.getC()) : "?"));
            retVal.append("\n[AI] = " + (this.myAI != null ? (Serializable)PrimitiveMatrix.FACTORY.copy(this.getAI()) : "?"));
            retVal.append("\n[BI] = " + (this.myBI != null ? (Serializable)PrimitiveMatrix.FACTORY.copy(this.getBI()) : "?"));
            retVal.append("\n</" + simpleName + ">");
            return retVal.toString();
        }

        public void validate() {
            if (this.hasEqualityConstraints()) {
                if (this.getAE() == null) {
                    throw new ProgrammingError("AE cannot be null!");
                }
                if (this.getAE().countColumns() != (long)this.countVariables()) {
                    throw new ProgrammingError("AE has the wrong number of columns!");
                }
                if (this.getAE().countRows() != this.getBE().countRows()) {
                    throw new ProgrammingError("AE and BE do not have the same number of rows!");
                }
                if (this.getBE().countColumns() != 1L) {
                    throw new ProgrammingError("BE must have precisely one column!");
                }
            } else {
                this.myAE = null;
                this.myBE = null;
            }
            if (this.hasObjective()) {
                if (this.getQ() != null && (this.getQ().countRows() != (long)this.countVariables() || this.getQ().countColumns() != (long)this.countVariables())) {
                    throw new ProgrammingError("Q has the wrong number of rows and/or columns!");
                }
                if (this.getC() != null && this.getC().countRows() != (long)this.countVariables() || this.getC().countColumns() != 1L) {
                    throw new ProgrammingError("C has the wrong number of rows and/or columns!");
                }
            } else {
                this.myQ = null;
                this.myC = null;
            }
            if (this.hasInequalityConstraints()) {
                if (this.getAI() == null) {
                    throw new ProgrammingError("AI cannot be null!");
                }
                if (this.getAI().countColumns() != (long)this.countVariables()) {
                    throw new ProgrammingError("AI has the wrong number of columns!");
                }
                if (this.getAI().countRows() != this.getBI().countRows()) {
                    throw new ProgrammingError("AI and BI do not have the same number of rows!");
                }
                if (this.getBI().countColumns() != 1L) {
                    throw new ProgrammingError("BI must have precisely one column!");
                }
            } else {
                this.myAI = null;
                this.myBI = null;
            }
        }

        @Override
        protected ConvexSolver doBuild(Optimisation.Options options) {
            this.validate();
            if (this.hasInequalityConstraints()) {
                return new IterativeASS(this, options);
            }
            if (this.hasEqualityConstraints()) {
                return new QPESolver(this, options);
            }
            return new UnconstrainedSolver(this, options);
        }
    }
}

