/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.integer;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;
import org.ojalgo.access.Access1D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.FunctionUtils;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.netio.CharacterRing;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.integer.IntegerSolver;
import org.ojalgo.optimisation.integer.NodeKey;
import org.ojalgo.type.TypeUtils;

public final class OldIntegerSolver
extends IntegerSolver {
    OldIntegerSolver(ExpressionsBasedModel model, Optimisation.Options solverOptions) {
        super(model, solverOptions);
    }

    @Override
    public Optimisation.Result solve(Optimisation.Result kickStarter) {
        if (kickStarter != null && kickStarter.getState().isFeasible() && this.getIntegerModel().validate(kickStarter)) {
            this.markInteger(null, null, kickStarter);
        }
        this.resetIterationsCount();
        BranchAndBoundNodeTask rootNodeTask = new BranchAndBoundNodeTask();
        boolean normalExit = ForkJoinPool.commonPool().invoke(rootNodeTask);
        Optimisation.Result bestSolutionFound = this.getBestResultSoFar();
        if (bestSolutionFound.getState().isFeasible()) {
            if (normalExit) {
                return new Optimisation.Result(Optimisation.State.OPTIMAL, bestSolutionFound);
            }
            return new Optimisation.Result(Optimisation.State.FEASIBLE, bestSolutionFound);
        }
        if (normalExit) {
            return new Optimisation.Result(Optimisation.State.INFEASIBLE, bestSolutionFound);
        }
        return new Optimisation.Result(Optimisation.State.FAILED, bestSolutionFound);
    }

    public String toString() {
        return TypeUtils.format("Solutions={} Nodes/Iterations={} {}", this.countIntegerSolutions(), this.countExploredNodes(), this.getBestResultSoFar());
    }

    @Override
    protected MatrixStore<Double> extractSolution() {
        return (MatrixStore)PrimitiveDenseStore.FACTORY.columns(this.getBestResultSoFar());
    }

    @Override
    protected boolean initialise(Optimisation.Result kickStarter) {
        return true;
    }

    @Override
    protected boolean needsAnotherIteration() {
        return !this.getState().isOptimal();
    }

    @Override
    protected boolean validate() {
        boolean retVal = true;
        this.setState(Optimisation.State.VALID);
        try {
            retVal = this.getIntegerModel().validate();
            if (!retVal) {
                retVal = false;
                this.setState(Optimisation.State.INVALID);
            }
        }
        catch (Exception ex) {
            retVal = false;
            this.setState(Optimisation.State.FAILED);
        }
        return retVal;
    }

    int countExploredNodes() {
        return 0;
    }

    void generateCuts(ExpressionsBasedModel nodeModel) {
    }

    boolean isExplored(BranchAndBoundNodeTask aNodeTask) {
        return false;
    }

    void markAsExplored(BranchAndBoundNodeTask aNodeTask) {
    }

    final class BranchAndBoundNodeTask
    extends RecursiveTask<Boolean> {
        private final NodeKey myKey;
        private final CharacterRing.PrinterBuffer myPrinter;

        private BranchAndBoundNodeTask(NodeKey key) {
            this.myPrinter = OldIntegerSolver.this.isDebug() ? new CharacterRing().asPrinter() : null;
            this.myKey = key;
        }

        BranchAndBoundNodeTask() {
            this.myPrinter = OldIntegerSolver.this.isDebug() ? new CharacterRing().asPrinter() : null;
            this.myKey = new NodeKey(OldIntegerSolver.this.getIntegerModel());
        }

        public String toString() {
            return this.myKey.toString();
        }

        private void flush(BasicLogger.Printer receiver) {
            if (this.myPrinter != null && receiver != null) {
                this.myPrinter.flush(receiver);
            }
        }

        private boolean isNodeDebug() {
            return this.myPrinter != null && OldIntegerSolver.this.isDebug();
        }

        @Override
        protected Boolean compute() {
            ExpressionsBasedModel nodeModel = OldIntegerSolver.this.getRelaxedModel();
            if (OldIntegerSolver.this.isIntegerSolutionFound()) {
                double mip_gap = OldIntegerSolver.this.options.mip_gap;
                double bestIntegerSolutionValue = OldIntegerSolver.this.getBestResultSoFar().getValue();
                double parentRelaxedSolutionValue = this.myKey.objective;
                double absoluteValue = PrimitiveFunction.ABS.invoke(bestIntegerSolutionValue);
                double absoluteGap = PrimitiveFunction.ABS.invoke(absoluteValue - parentRelaxedSolutionValue);
                double small = FunctionUtils.max(mip_gap, absoluteGap * mip_gap, absoluteValue * mip_gap);
                if (nodeModel.isMinimisation()) {
                    BigDecimal upperLimit = TypeUtils.toBigDecimal(bestIntegerSolutionValue - small, OldIntegerSolver.this.options.feasibility);
                    nodeModel.limitObjective(null, upperLimit);
                } else {
                    BigDecimal lowerLimit = TypeUtils.toBigDecimal(bestIntegerSolutionValue + small, OldIntegerSolver.this.options.feasibility);
                    nodeModel.limitObjective(lowerLimit, null);
                }
            }
            return this.compute(nodeModel);
        }

        protected Boolean compute(ExpressionsBasedModel nodeModel) {
            if (this.isNodeDebug()) {
                this.myPrinter.println();
                this.myPrinter.println("Branch&Bound Node");
                this.myPrinter.println(this.myKey.toString());
                this.myPrinter.println(OldIntegerSolver.this.toString());
            }
            if (!OldIntegerSolver.this.isIterationAllowed() || !OldIntegerSolver.this.isIterationNecessary()) {
                if (this.isNodeDebug()) {
                    this.myPrinter.println("Reached iterations or time limit - stop!");
                    this.flush(OldIntegerSolver.this.getIntegerModel().options.logger_appender);
                }
                return false;
            }
            if (!OldIntegerSolver.this.isGoodEnoughToContinueBranching(this.myKey.objective)) {
                if (this.isNodeDebug()) {
                    this.myPrinter.println("No longer a relevant node!");
                    this.flush(OldIntegerSolver.this.getIntegerModel().options.logger_appender);
                }
                return true;
            }
            this.myKey.bound(nodeModel, OldIntegerSolver.this.getIntegerIndices());
            Optimisation.Result bestResultSoFar = OldIntegerSolver.this.getBestResultSoFar();
            Optimisation.Result nodeResult = nodeModel.solve(bestResultSoFar);
            OldIntegerSolver.this.incrementIterationsCount();
            if (this.isNodeDebug()) {
                this.myPrinter.println("Node Result: {}", nodeResult);
            }
            if (nodeResult.getState().isOptimal()) {
                if (this.isNodeDebug()) {
                    this.myPrinter.println("Node solved to optimality!");
                }
                if (OldIntegerSolver.this.options.validate && !nodeModel.validate(nodeResult)) {
                    this.myPrinter.println("Node solution marked as OPTIMAL, but is actually INVALID/INFEASIBLE/FAILED. Stop this branch!");
                    this.myPrinter.println("Lower bounds: {}", Arrays.toString(this.myKey.getLowerBounds()));
                    this.myPrinter.println("Upper bounds: {}", Arrays.toString(this.myKey.getUpperBounds()));
                    nodeModel.validate((Access1D<BigDecimal>)nodeResult, (BasicLogger.Printer)this.myPrinter);
                    this.flush(OldIntegerSolver.this.getIntegerModel().options.logger_appender);
                    return false;
                }
                int tmpBranchIndex = OldIntegerSolver.this.identifyNonIntegerVariable(nodeResult, this.myKey);
                double tmpSolutionValue = OldIntegerSolver.this.evaluateFunction(nodeResult);
                if (tmpBranchIndex == -1) {
                    if (this.isNodeDebug()) {
                        this.myPrinter.println("Integer solution! Store it among the others, and stop this branch!");
                    }
                    Optimisation.Result tmpIntegerSolutionResult = new Optimisation.Result(Optimisation.State.FEASIBLE, tmpSolutionValue, nodeResult);
                    OldIntegerSolver.this.markInteger(this.myKey, null, tmpIntegerSolutionResult);
                    if (this.isNodeDebug()) {
                        this.myPrinter.println(OldIntegerSolver.this.getBestResultSoFar().toString());
                        BasicLogger.debug();
                        BasicLogger.debug(OldIntegerSolver.this.toString());
                        this.flush(OldIntegerSolver.this.getIntegerModel().options.logger_appender);
                    }
                    nodeModel.dispose();
                    return true;
                }
                if (this.isNodeDebug()) {
                    this.myPrinter.println("Not an Integer Solution: " + tmpSolutionValue);
                }
                double tmpVariableValue = nodeResult.doubleValue(OldIntegerSolver.this.getGlobalIndex(tmpBranchIndex));
                if (OldIntegerSolver.this.isGoodEnoughToContinueBranching(tmpSolutionValue)) {
                    BranchAndBoundNodeTask forkedTask;
                    BranchAndBoundNodeTask nextTask;
                    if (this.isNodeDebug()) {
                        this.myPrinter.println("Still hope, branching on {} @ {} >>> {}", tmpBranchIndex, tmpVariableValue, nodeModel.getVariable(OldIntegerSolver.this.getGlobalIndex(tmpBranchIndex)));
                        this.flush(OldIntegerSolver.this.getIntegerModel().options.logger_appender);
                    }
                    OldIntegerSolver.this.generateCuts(nodeModel);
                    BranchAndBoundNodeTask lowerBranch = this.createLowerBranch(tmpBranchIndex, tmpVariableValue, tmpSolutionValue);
                    BranchAndBoundNodeTask upperBranch = this.createUpperBranch(tmpBranchIndex, tmpVariableValue, tmpSolutionValue);
                    if (tmpVariableValue - Math.floor(tmpVariableValue) > PrimitiveMath.HALF) {
                        nextTask = upperBranch;
                        forkedTask = lowerBranch;
                    } else {
                        nextTask = lowerBranch;
                        forkedTask = upperBranch;
                    }
                    forkedTask.fork();
                    return nextTask.compute(nodeModel) != false && (Boolean)forkedTask.join() != false;
                }
                if (this.isNodeDebug()) {
                    this.myPrinter.println("Can't find better integer solutions - stop this branch!");
                    this.flush(OldIntegerSolver.this.getIntegerModel().options.logger_appender);
                }
                nodeModel.dispose();
                return true;
            }
            if (this.isNodeDebug()) {
                this.myPrinter.println("Failed to solve node problem - stop this branch!");
                this.flush(OldIntegerSolver.this.getIntegerModel().options.logger_appender);
            }
            nodeModel.dispose();
            return true;
        }

        BranchAndBoundNodeTask createLowerBranch(int branchIndex, double nonIntegerValue, double parentObjectiveValue) {
            NodeKey tmpKey = this.myKey.createLowerBranch(branchIndex, nonIntegerValue, parentObjectiveValue);
            return new BranchAndBoundNodeTask(tmpKey);
        }

        BranchAndBoundNodeTask createUpperBranch(int branchIndex, double nonIntegerValue, double parentObjectiveValue) {
            NodeKey tmpKey = this.myKey.createUpperBranch(branchIndex, nonIntegerValue, parentObjectiveValue);
            return new BranchAndBoundNodeTask(tmpKey);
        }

        NodeKey getKey() {
            return this.myKey;
        }
    }
}

