/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import com.sun.javafx.animation.AnimationTimerHelper;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Utils;
import com.sun.scenario.animation.AbstractPrimaryTimer;
import com.sun.scenario.animation.shared.TimerReceiver;
import java.security.AccessControlContext;
import java.security.AccessController;

public abstract class AnimationTimer {
    private final AbstractPrimaryTimer timer;
    private final AnimationTimerReceiver timerReceiver = new AnimationTimerReceiver();
    private boolean active;
    private AccessControlContext accessCtrlCtx = null;

    public AnimationTimer() {
        this.timer = Toolkit.getToolkit().getPrimaryTimer();
    }

    AnimationTimer(AbstractPrimaryTimer abstractPrimaryTimer) {
        this.timer = abstractPrimaryTimer;
    }

    public abstract void handle(long var1);

    public void start() {
        Utils.runOnFxThread(this::startImpl);
    }

    private void startImpl() {
        if (!this.active) {
            this.accessCtrlCtx = AccessController.getContext();
            this.timer.addAnimationTimer(this.timerReceiver);
            this.active = true;
        }
    }

    public void stop() {
        Utils.runOnFxThread(this::stopImpl);
    }

    private void stopImpl() {
        if (this.active) {
            this.timer.removeAnimationTimer(this.timerReceiver);
            this.active = false;
        }
    }

    static {
        AnimationTimerHelper.setAccessor(new AnimationTimerHelper.Accessor(){

            @Override
            public AbstractPrimaryTimer getPrimaryTimer(AnimationTimer animationTimer) {
                return animationTimer.timer;
            }
        });
    }

    private class AnimationTimerReceiver
    implements TimerReceiver {
        private AnimationTimerReceiver() {
        }

        @Override
        public void handle(long l) {
            if (AnimationTimer.this.accessCtrlCtx == null) {
                throw new IllegalStateException("Error: AccessControlContext not captured");
            }
            AccessController.doPrivileged(() -> {
                AnimationTimer.this.handle(l);
                return null;
            }, AnimationTimer.this.accessCtrlCtx);
        }
    }
}

