/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.MenuElement;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import org.fife.rsta.ac.LanguageSupport;
import org.fife.rsta.ac.LanguageSupportFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.parser.TaskTagParser;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.GutterIconInfo;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.RecordableTextAction;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.scijava.Context;
import org.scijava.log.LogService;
import org.scijava.platform.PlatformService;
import org.scijava.plugin.Parameter;
import org.scijava.prefs.PrefService;
import org.scijava.script.ScriptHeaderService;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptService;
import org.scijava.ui.swing.script.Bookmark;
import org.scijava.ui.swing.script.EditorPaneActions;
import org.scijava.ui.swing.script.ErrorParser;
import org.scijava.ui.swing.script.GutterUtils;
import org.scijava.ui.swing.script.LanguageSupportService;
import org.scijava.ui.swing.script.TextEditor;
import org.scijava.ui.swing.script.TextEditorTab;
import org.scijava.ui.swing.script.TokenFunctions;
import org.scijava.util.FileUtils;

public class EditorPane
extends RSyntaxTextArea
implements DocumentListener {
    private String fallBackBaseName;
    private File curFile;
    private File gitDirectory;
    private long fileLastModified;
    private ScriptLanguage currentLanguage;
    private Gutter gutter;
    private int modifyCount;
    private boolean undoInProgress;
    private boolean redoInProgress;
    private boolean autoCompletionEnabled;
    private boolean autoCompletionJavaFallback;
    private boolean autoCompletionWithoutKey;
    private String supportStatus;
    private final ErrorParser errorHighlighter = new ErrorParser(this);
    private final JMenu noneLangSyntaxMenu;
    private final EditorPaneActions actions = new EditorPaneActions(this);
    @Parameter
    Context context;
    @Parameter
    private LanguageSupportService languageSupportService;
    @Parameter
    private ScriptService scriptService;
    @Parameter
    private ScriptHeaderService scriptHeaderService;
    @Parameter
    private PrefService prefService;
    @Parameter
    private PlatformService platformService;
    @Parameter
    private LogService log;
    public static final String FONT_SIZE_PREFS = "script.editor.FontSize";
    public static final String LINE_WRAP_PREFS = "script.editor.WrapLines";
    public static final String TAB_SIZE_PREFS = "script.editor.TabSize";
    public static final String TABS_EMULATED_PREFS = "script.editor.TabsEmulated";
    public static final String WHITESPACE_VISIBLE_PREFS = "script.editor.Whitespace";
    public static final String TABLINES_VISIBLE_PREFS = "script.editor.Tablines";
    public static final String MARGIN_VISIBLE_PREFS = "script.editor.Margin";
    public static final String THEME_PREFS = "script.editor.theme";
    public static final String AUTOCOMPLETE_PREFS = "script.editor.AC";
    public static final String AUTOCOMPLETE_KEYLESS_PREFS = "script.editor.ACNoKey";
    public static final String AUTOCOMPLETE_FALLBACK_PREFS = "script.editor.ACFallback";
    public static final String MARK_OCCURRENCES_PREFS = "script.editor.Occurrences";
    public static final String FOLDERS_PREFS = "script.editor.folders";
    public static final int DEFAULT_TAB_SIZE = 4;
    public static final String DEFAULT_THEME = "default";

    public EditorPane() {
        this.setAntiAliasingEnabled(true);
        this.setAutoIndentEnabled(true);
        this.setBracketMatchingEnabled(true);
        this.setCloseCurlyBraces(true);
        this.setCloseMarkupTags(true);
        this.setCodeFoldingEnabled(true);
        this.setShowMatchedBracketPopup(true);
        this.setClearWhitespaceLinesEnabled(false);
        this.setHyperlinksEnabled(true);
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hle) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                    try {
                        EditorPane.this.platformService.open(hle.getURL());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        this.addParser((Parser)new TaskTagParser());
        this.getActionMap().put("caret-next-word", (Action)this.wordMovement("Next-Word-Action", 1, false));
        this.getActionMap().put("selection-next-word", (Action)this.wordMovement("Next-Word-Select-Action", 1, true));
        this.getActionMap().put("caret-previous-word", (Action)this.wordMovement("Prev-Word-Action", -1, false));
        this.getActionMap().put("selection-previous-word", (Action)this.wordMovement("Prev-Word-Select-Action", -1, true));
        this.noneLangSyntaxMenu = this.geSyntaxForNoneLang();
        this.installCustomPopupMenu();
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        this.addMouseListener(new MouseAdapter(){
            SearchContext context;

            @Override
            public void mousePressed(MouseEvent me) {
                if (EditorPane.this.getMarkOccurrences() && 2 == me.getClickCount()) {
                    String str = EditorPane.this.getSelectedText();
                    if (str == null || str.trim().isEmpty()) {
                        return;
                    }
                    if (this.context != null && str.equals(this.context.getSearchFor())) {
                        SearchEngine.markAll((RTextArea)EditorPane.this, (SearchContext)new SearchContext());
                        this.context = null;
                    } else {
                        Color stashedColor = EditorPane.this.getMarkAllHighlightColor();
                        EditorPane.this.setMarkAllHighlightColor(EditorPane.this.getMarkOccurrencesColor());
                        this.context = new SearchContext(str, true);
                        this.context.setMarkAll(true);
                        this.context.setWholeWord(true);
                        SearchEngine.markAll((RTextArea)EditorPane.this, (SearchContext)this.context);
                        EditorPane.this.setMarkAllHighlightColor(stashedColor);
                    }
                }
            }
        });
    }

    protected boolean isLocked() {
        return !this.isEditable() || !this.isEnabled();
    }

    public void addNotify() {
        if (this.isVisible()) {
            super.addNotify();
        }
    }

    private void installCustomPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        TextEditor.GuiUtils.addPopupMenuSeparator(popup, "Code Editing:");
        popup.add(this.getMenuItem("Copy", "copy-to-clipboard", false));
        popup.add(this.getMenuItem("Cut", "cut-to-clipboard", true));
        popup.add(this.getMenuItem("Paste", "paste-from-clipboard", true));
        popup.add(this.getMenuItem("Delete Line", "RTA.DeleteLineAction", true));
        popup.add(this.getMenuItem("Delete Rest of Line", "RTA.DeleteRestOfLineAction", true));
        TextEditor.GuiUtils.addPopupMenuSeparator(popup, "Code Selection:");
        popup.add(this.getMenuItem("Select All", "select-all", false));
        popup.add(this.getMenuItem("Select Line", "select-line", false));
        popup.add(this.getMenuItem("Select Paragraph", "select-paragraph", false));
        TextEditor.GuiUtils.addPopupMenuSeparator(popup, "Code Folding:");
        popup.add(this.getMenuItem("Collapse Fold", "RSTA.CollapseFoldAction", false));
        popup.add(this.getMenuItem("Expand Fold", "RSTA.ExpandFoldAction", false));
        popup.add(this.getMenuItem("Toggle Current Fold", "RSTA.ToggleCurrentFoldAction", false));
        popup.add(this.getMenuItem("Collapse All Folds", "RSTA.CollapseAllFoldsAction", false));
        popup.add(this.getMenuItem("Expand All Folds", "RSTA.ExpandAllFoldsAction", false));
        popup.add(this.getMenuItem("Collapse All Comments", "RSTA.CollapseAllCommentFoldsAction", false));
        TextEditor.GuiUtils.addPopupMenuSeparator(popup, "Code Formatting:");
        popup.add(this.getMenuItem("Indent Right", "RSTA.IncreaseIndentAction", true));
        popup.add(this.getMenuItem("Indent Left", "RSTA.DecreaseIndentAction", true));
        popup.add(this.getMenuItem("Move Up", "RTA.LineUpAction", true));
        popup.add(this.getMenuItem("Move Down", "RTA.LineDownAction", true));
        popup.add(this.getMenuItem("Join Lines", "RTA.JoinLinesAction", true));
        JMenu menu = new JMenu("Transform Case");
        popup.add(menu);
        menu.add(this.getMenuItem("Invert Case", "RTA.InvertCaseAction", true));
        menu.addSeparator();
        menu.add(this.getMenuItem("Camel Case", "RTA.CamelCaseAction", true));
        menu.add(this.getMenuItem("Lower Case", "RTA.LowerCaseAction", true));
        menu.add(this.getMenuItem("Lower Case ('_' Sep.)", "RTA.LowerCaseUnderscoreSep.Action", true));
        menu.add(this.getMenuItem("Title Case", "RTA.TitleCaseAction", true));
        menu.add(this.getMenuItem("Upper Case", "RTA.UpperCaseAction", true));
        TextEditor.GuiUtils.addPopupMenuSeparator(popup, "Ocurrences:");
        popup.add(this.getMenuItem("Next Occurrence", "RTA.NextOccurrenceAction", false));
        popup.add(this.getMenuItem("Previous Occurrence", "RTA.PrevOccurrenceAction", false));
        TextEditor.GuiUtils.addPopupMenuSeparator(popup, "Utilities:");
        popup.add(new OpenLinkUnderCursor().getMenuItem());
        popup.add(new SearchWebOnSelectedText().getMenuItem());
        popup.add(this.noneLangSyntaxMenu);
        super.setPopupMenu(popup);
    }

    private JMenuItem getMenuItem(String label, String actionID, boolean editingAction) {
        Action action = this.getActionMap().get(actionID);
        JMenuItem jmi = new JMenuItem(action);
        jmi.setAccelerator(this.getPaneActions().getAccelerator(actionID));
        jmi.setText(label);
        return jmi;
    }

    private JMenu geSyntaxForNoneLang() {
        JMenu menu = new JMenu("Non-Executable Syntax");
        menu.setToolTipText("Markup languages when scripting language is none");
        ButtonGroup bg = new ButtonGroup();
        menu.add(this.getSyntaxItem(bg, "None", "text/plain"));
        bg.getElements().nextElement().setSelected(true);
        menu.addSeparator();
        menu.add(this.getSyntaxItem(bg, "BAT", "text/bat"));
        menu.add(this.getSyntaxItem(bg, "CSS", "text/css"));
        menu.add(this.getSyntaxItem(bg, "Dockerfile", "text/dockerfile"));
        menu.add(this.getSyntaxItem(bg, "HTML", "text/html"));
        menu.add(this.getSyntaxItem(bg, "JSON", "text/json"));
        menu.add(this.getSyntaxItem(bg, "Kotlin", "text/kotlin"));
        menu.add(this.getSyntaxItem(bg, "Makefile", "text/makefile"));
        menu.add(this.getSyntaxItem(bg, "Markdown", "text/markdown"));
        menu.add(this.getSyntaxItem(bg, "SH", "text/unix"));
        menu.add(this.getSyntaxItem(bg, "XML", "text/xml"));
        menu.add(this.getSyntaxItem(bg, "YAML", "text/yaml"));
        return menu;
    }

    private JMenuItem getSyntaxItem(ButtonGroup bg, String label, String syntaxId) {
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(label);
        bg.add(item);
        item.addActionListener(e -> {
            if (this.getCurrentLanguage() == null) {
                this.setSyntaxEditingStyle(syntaxId);
            } else {
                this.error("Non-executable syntaxes can only be applied when scripting language is 'None'.");
                bg.getElements().nextElement().setSelected(true);
                this.setSyntaxEditingStyle("text/plain");
            }
        });
        return item;
    }

    void error(String message) {
        TextEditor.GuiUtils.error((Component)((Object)this), message);
    }

    private void updateNoneLangSyntaxMenu(ScriptLanguage language) {
        this.noneLangSyntaxMenu.setEnabled(language == null);
        if (language == null) {
            AbstractButton defaultChoice = null;
            try {
                for (MenuElement me : this.noneLangSyntaxMenu.getSubElements()) {
                    if (!(me instanceof JRadioButtonMenuItem)) continue;
                    JRadioButtonMenuItem rb = (JRadioButtonMenuItem)me;
                    String choice = rb.getActionCommand();
                    if (this.getSyntaxEditingStyle().equals(choice)) {
                        rb.setSelected(true);
                        return;
                    }
                    if (!"text/plain".equals(choice)) continue;
                    defaultChoice = rb;
                }
                defaultChoice.setSelected(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setTabSize(int width) {
        if (this.getTabSize() != width) {
            super.setTabSize(width);
        }
    }

    public void embedWithScrollbars(Container container) {
        container.add((Component)this.wrappedInScrollbars());
    }

    public RTextScrollPane wrappedInScrollbars() {
        RTextScrollPane sp = new RTextScrollPane((RTextArea)this);
        sp.setPreferredSize(new Dimension(600, 350));
        sp.setIconRowHeaderEnabled(true);
        this.gutter = sp.getGutter();
        this.gutter.setBookmarkingEnabled(true);
        this.gutter.setShowCollapsedRegionToolTips(true);
        this.gutter.setFoldIndicatorEnabled(true);
        GutterUtils.updateIcons(this.gutter);
        return sp;
    }

    RecordableTextAction wordMovement(final String id, final int direction, final boolean select) {
        return new RecordableTextAction(id){
            private static final long serialVersionUID = 1L;

            public String getDescription() {
                StringBuilder sb = new StringBuilder();
                if (direction > 0) {
                    sb.append("Next");
                } else {
                    sb.append("Previous");
                }
                sb.append("Word");
                if (select) {
                    sb.append("Select");
                }
                return sb.toString();
            }

            public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
                int pos;
                int end;
                int n = end = direction < 0 ? 0 : textArea.getDocument().getLength();
                for (pos = textArea.getCaretPosition(); pos != end && !this.isWordChar(textArea, pos); pos += direction) {
                }
                while (pos != end && this.isWordChar(textArea, pos)) {
                    pos += direction;
                }
                if (select) {
                    textArea.moveCaretPosition(pos);
                } else {
                    textArea.setCaretPosition(pos);
                }
            }

            public String getMacroID() {
                return id;
            }

            boolean isWordChar(RTextArea textArea, int pos) {
                try {
                    char c = textArea.getText(pos + (direction < 0 ? -1 : 0), 1).charAt(0);
                    return c > '\u007f' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_';
                }
                catch (BadLocationException e) {
                    return false;
                }
            }
        };
    }

    public void undoLastAction() {
        this.undoInProgress = true;
        super.undoLastAction();
        this.undoInProgress = false;
    }

    public void redoLastAction() {
        this.redoInProgress = true;
        super.redoLastAction();
        this.redoInProgress = false;
    }

    public boolean fileChanged() {
        return this.modifyCount != 0;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.modified();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.modified();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    protected void modified() {
        this.modifyCount = this.undoInProgress ? --this.modifyCount : (this.redoInProgress || this.modifyCount >= 0 ? ++this.modifyCount : Integer.MIN_VALUE);
    }

    public boolean isNew() {
        return !this.fileChanged() && this.curFile == null && this.fallBackBaseName == null && this.getDocument().getLength() == 0;
    }

    public boolean wasChangedOutside() {
        return this.curFile != null && this.curFile.exists() && this.curFile.lastModified() != this.fileLastModified;
    }

    public void write(File file) throws IOException {
        File dir = file.getParentFile();
        if (dir != null && !dir.exists() && !dir.mkdirs()) {
            throw new IOException("Cannot create directory: " + dir);
        }
        BufferedWriter outFile = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        outFile.write(this.getText());
        outFile.close();
        this.modifyCount = 0;
        this.fileLastModified = file.lastModified();
    }

    public void open(File file) throws IOException {
        File oldFile = this.curFile;
        this.curFile = null;
        if (file == null) {
            this.setText("");
        } else {
            int line = 0;
            try {
                if (file.getCanonicalPath().equals(oldFile.getCanonicalPath())) {
                    line = this.getCaretLineNumber();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!file.exists()) {
                this.modifyCount = Integer.MIN_VALUE;
                this.setFileName(file);
                return;
            }
            StringBuffer string = new StringBuffer();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
                int count;
                char[] buffer = new char[16384];
                while ((count = reader.read(buffer)) >= 0) {
                    string.append(buffer, 0, count);
                }
                reader.close();
            }
            try {
                this.setText(string.toString());
            }
            catch (Error | IndexOutOfBoundsException e2) {
                this.log.debug(e2);
            }
            this.curFile = file;
            if (line > this.getLineCount()) {
                line = this.getLineCount() - 1;
            }
            try {
                this.setCaretPosition(this.getLineStartOffset(line));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.discardAllEdits();
        this.fileLastModified = file == null || !file.exists() ? 0L : file.lastModified();
        this.modifyCount = 0;
        this.getDocument().addDocumentListener(this);
    }

    public void setFileName(String baseName) {
        this.fallBackBaseName = baseName;
        if (this.currentLanguage == null) {
            return;
        }
        for (String extension : this.currentLanguage.getExtensions()) {
            extension = "." + extension;
            if (!baseName.endsWith(extension)) continue;
            this.fallBackBaseName = this.fallBackBaseName.substring(0, this.fallBackBaseName.length() - extension.length());
            break;
        }
        if (this.currentLanguage.getLanguageName().equals("Java")) {
            new TokenFunctions(this).setClassName(this.fallBackBaseName);
        }
    }

    public void setFileName(File file) {
        this.curFile = file;
        if (file != null) {
            this.setLanguageByFileName(file.getName());
            this.fallBackBaseName = null;
        }
        this.fileLastModified = file == null || !file.exists() ? 0L : file.lastModified();
    }

    public File getGitDirectory() {
        return this.gitDirectory;
    }

    public void setGitDirectory(File dir) {
        this.gitDirectory = dir;
    }

    protected String getFileName() {
        if (this.curFile != null) {
            return this.curFile.getName();
        }
        String extension = "";
        if (this.currentLanguage != null) {
            List extensions = this.currentLanguage.getExtensions();
            if (extensions.size() > 0) {
                extension = "." + (String)extensions.get(0);
            }
            if (this.currentLanguage.getLanguageName().equals("Java")) {
                try {
                    String name = new TokenFunctions(this).getClassName();
                    if (name != null) {
                        return name + extension;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return (this.fallBackBaseName == null ? "New_" : this.fallBackBaseName) + extension;
    }

    protected void setLanguageByFileName(String name) {
        this.setLanguage(this.scriptService.getLanguageByExtension(FileUtils.getExtension((String)name)));
    }

    protected void setLanguage(ScriptLanguage language) {
        this.setLanguage(language, false);
    }

    protected void setLanguage(ScriptLanguage language, boolean addHeader) {
        String defaultExtension;
        String languageName;
        LanguageSupport support = this.languageSupportService.getLanguageSupport(this.currentLanguage);
        if (support != null) {
            support.uninstall((RSyntaxTextArea)this);
        }
        if (language == null) {
            languageName = "None";
            defaultExtension = ".txt";
        } else {
            languageName = language.getLanguageName();
            List extensions = language.getExtensions();
            String string = defaultExtension = extensions.size() == 0 ? "" : "." + (String)extensions.get(0);
        }
        if (this.fallBackBaseName != null && this.fallBackBaseName.endsWith(".txt")) {
            this.fallBackBaseName = this.fallBackBaseName.substring(0, this.fallBackBaseName.length() - 4);
        }
        if (this.curFile != null) {
            String name = this.curFile.getName();
            String ext = "." + FileUtils.getExtension((String)name);
            if (!defaultExtension.equals(ext)) {
                name = name.substring(0, name.length() - ext.length());
                this.curFile = new File(this.curFile.getParentFile(), name + defaultExtension);
                this.modifyCount = Integer.MIN_VALUE;
            }
        }
        String header = null;
        if (addHeader && this.currentLanguage == null) {
            header = this.scriptHeaderService.getHeader(language);
        }
        this.currentLanguage = language;
        String styleName = "text/" + languageName.toLowerCase().replace(' ', '-');
        try {
            this.setSyntaxEditingStyle(styleName);
        }
        catch (IndexOutOfBoundsException | NullPointerException exc) {
            this.log.debug((Throwable)exc);
        }
        if (header != null) {
            header = header + this.getText();
            this.setText(header);
        }
        this.updateNoneLangSyntaxMenu(language);
        if ("None".equals(languageName)) {
            this.supportStatus = "Active language: None";
            return;
        }
        String supportLevel = "SciJava supported";
        support = this.languageSupportService.getLanguageSupport(this.currentLanguage);
        if (support == null) {
            support = LanguageSupportFactory.get().getSupportFor(styleName);
            supportLevel = "Legacy supported";
        }
        if (support == null && this.autoCompletionJavaFallback) {
            support = this.languageSupportService.getLanguageSupport(this.scriptService.getLanguageByName("Java"));
            supportLevel = "N/A. Using Java as fallback";
        }
        if (support != null) {
            support.setAutoCompleteEnabled(this.autoCompletionEnabled);
            support.setAutoActivationEnabled(this.autoCompletionWithoutKey);
            support.install((RSyntaxTextArea)this);
            if (!this.autoCompletionEnabled) {
                supportLevel = supportLevel + " but currently disabled\n";
            } else {
                supportLevel = supportLevel + " triggered by Ctrl+Space";
                if (this.autoCompletionWithoutKey) {
                    supportLevel = supportLevel + " & auto-display ";
                }
                supportLevel = supportLevel + "\n";
            }
        } else {
            supportLevel = "N/A";
        }
        this.supportStatus = "Active language: " + languageName + "\nAutocompletion: " + supportLevel;
    }

    public void setAutoCompletion(boolean enabled) {
        this.autoCompletionEnabled = enabled;
        if (this.currentLanguage != null) {
            this.setLanguage(this.currentLanguage);
        }
    }

    void setFallbackAutoCompletion(boolean value) {
        this.autoCompletionJavaFallback = value;
        if (this.autoCompletionEnabled && this.currentLanguage != null) {
            this.setLanguage(this.currentLanguage);
        }
    }

    void setKeylessAutoCompletion(boolean enabled) {
        this.autoCompletionWithoutKey = enabled;
        if (this.autoCompletionEnabled && this.currentLanguage != null) {
            this.setLanguage(this.currentLanguage);
        }
    }

    public boolean isAutoCompletionEnabled() {
        return this.autoCompletionEnabled;
    }

    public boolean isAutoCompletionKeyless() {
        return this.autoCompletionWithoutKey;
    }

    public boolean isAutoCompletionFallbackEnabled() {
        return this.autoCompletionJavaFallback;
    }

    public File getFile() {
        return this.curFile;
    }

    public ScriptLanguage getCurrentLanguage() {
        return this.currentLanguage;
    }

    public float getFontSize() {
        return this.getFont().getSize2D();
    }

    public void setFontSize(float size) {
        this.increaseFontSize(size / this.getFontSize());
    }

    public void increaseFontSize(float factor) {
        Container parent;
        if (factor == 1.0f) {
            return;
        }
        SyntaxScheme scheme = this.getSyntaxScheme();
        for (int i = 0; i < scheme.getStyleCount(); ++i) {
            Style style = scheme.getStyle(i);
            if (style == null || style.font == null) continue;
            float size = Math.max(5.0f, style.font.getSize2D() * factor);
            style.font = style.font.deriveFont(size);
        }
        Font font = this.getFont();
        float size = Math.max(5.0f, font.getSize2D() * factor);
        this.setFont(font.deriveFont(size));
        this.setSyntaxScheme(scheme);
        if (this.gutter != null) {
            float lnSize = size * 0.8f;
            this.gutter.setLineNumberFont(font.deriveFont(lnSize));
            GutterUtils.updateIcons(this.gutter);
        }
        if ((parent = this.getParent()) instanceof JViewport && (parent = parent.getParent()) instanceof JScrollPane) {
            parent.repaint();
        }
        parent.repaint();
    }

    protected RSyntaxDocument getRSyntaxDocument() {
        return (RSyntaxDocument)this.getDocument();
    }

    public void toggleBookmark() {
        this.toggleBookmark(this.getCaretLineNumber());
    }

    public void toggleBookmark(int line) {
        if (this.gutter != null) {
            try {
                this.gutter.toggleBookmark(line);
            }
            catch (BadLocationException e) {
                this.error("Cannot toggle bookmark at this location.");
            }
        }
    }

    public void getBookmarks(TextEditorTab tab, Collection<Bookmark> result) {
        if (this.gutter == null) {
            return;
        }
        for (GutterIconInfo info : this.gutter.getBookmarks()) {
            result.add(new Bookmark(tab, info));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int zapGremlins() {
        char[] chars = this.getText().toCharArray();
        int count = 0;
        boolean inQuotes = false;
        char quoteChar = '\u0000';
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (!inQuotes) {
                if (c == '\"' || c == '\'') {
                    inQuotes = true;
                    quoteChar = c;
                    continue;
                }
                if (c == '\n' || c == '\t' || c >= ' ' && c <= '\u007f') continue;
                ++count;
                chars[i] = 32;
                continue;
            }
            if (c != quoteChar && c != '\n') continue;
            inQuotes = false;
        }
        if (count > 0) {
            this.beginAtomicEdit();
            try {
                this.setText(new String(chars));
            }
            catch (Throwable t) {
                this.log.error(t);
            }
            finally {
                this.endAtomicEdit();
            }
        }
        return count;
    }

    public void convertTabsToSpaces() {
        this.beginAtomicEdit();
        try {
            super.convertTabsToSpaces();
        }
        catch (Throwable t) {
            this.log.error(t);
        }
        finally {
            this.endAtomicEdit();
        }
    }

    public void convertSpacesToTabs() {
        this.beginAtomicEdit();
        try {
            super.convertSpacesToTabs();
        }
        catch (Throwable t) {
            this.log.error(t);
        }
        finally {
            this.endAtomicEdit();
        }
    }

    public void loadPreferences() {
        if (this.prefService == null) {
            this.setLineWrap(false);
            this.setTabSize(4);
            this.setLineWrap(false);
            this.setTabsEmulated(false);
            this.setPaintTabLines(false);
            this.setAutoCompletion(true);
            this.setKeylessAutoCompletion(true);
            this.setFallbackAutoCompletion(false);
            this.setMarkOccurrences(false);
        } else {
            this.resetTabSize();
            this.setFontSize(this.prefService.getFloat(this.getClass(), FONT_SIZE_PREFS, this.getFontSize()));
            this.setLineWrap(this.prefService.getBoolean(this.getClass(), LINE_WRAP_PREFS, this.getLineWrap()));
            this.setTabsEmulated(this.prefService.getBoolean(this.getClass(), TABS_EMULATED_PREFS, this.getTabsEmulated()));
            this.setWhitespaceVisible(this.prefService.getBoolean(this.getClass(), WHITESPACE_VISIBLE_PREFS, this.isWhitespaceVisible()));
            this.setPaintTabLines(this.prefService.getBoolean(this.getClass(), TABLINES_VISIBLE_PREFS, this.getPaintTabLines()));
            this.setAutoCompletion(this.prefService.getBoolean(this.getClass(), AUTOCOMPLETE_PREFS, true));
            this.setKeylessAutoCompletion(this.prefService.getBoolean(this.getClass(), AUTOCOMPLETE_KEYLESS_PREFS, true));
            this.setFallbackAutoCompletion(this.prefService.getBoolean(this.getClass(), AUTOCOMPLETE_FALLBACK_PREFS, false));
            this.setMarkOccurrences(this.prefService.getBoolean(this.getClass(), MARK_OCCURRENCES_PREFS, false));
            this.setMarginLineEnabled(this.prefService.getBoolean(this.getClass(), MARGIN_VISIBLE_PREFS, false));
            this.applyTheme(this.themeName());
        }
    }

    public void applyTheme(String theme) throws IllegalArgumentException {
        try {
            this.applyTheme(TextEditor.getTheme(theme));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public String themeName() {
        return this.prefService.get(this.getClass(), THEME_PREFS, DEFAULT_THEME);
    }

    private void applyTheme(Theme th) throws IllegalArgumentException {
        float existingFontSize = this.getFontSize();
        th.apply((RSyntaxTextArea)this);
        this.setFontSize(existingFontSize);
        GutterUtils.updateIcons(this.gutter);
    }

    public String loadFolders() {
        return this.prefService.get(this.getClass(), FOLDERS_PREFS, System.getProperty("user.home"));
    }

    public void savePreferences(String top_folders, String theme) {
        this.prefService.put(this.getClass(), TAB_SIZE_PREFS, this.getTabSize());
        this.prefService.put(this.getClass(), FONT_SIZE_PREFS, this.getFontSize());
        this.prefService.put(this.getClass(), LINE_WRAP_PREFS, this.getLineWrap());
        this.prefService.put(this.getClass(), TABS_EMULATED_PREFS, this.getTabsEmulated());
        this.prefService.put(this.getClass(), WHITESPACE_VISIBLE_PREFS, this.isWhitespaceVisible());
        this.prefService.put(this.getClass(), TABLINES_VISIBLE_PREFS, this.getPaintTabLines());
        this.prefService.put(this.getClass(), AUTOCOMPLETE_PREFS, this.isAutoCompletionEnabled());
        this.prefService.put(this.getClass(), AUTOCOMPLETE_KEYLESS_PREFS, this.isAutoCompletionKeyless());
        this.prefService.put(this.getClass(), AUTOCOMPLETE_FALLBACK_PREFS, this.isAutoCompletionFallbackEnabled());
        this.prefService.put(this.getClass(), MARGIN_VISIBLE_PREFS, this.isMarginLineEnabled());
        this.prefService.put(this.getClass(), MARK_OCCURRENCES_PREFS, this.getMarkOccurrences());
        if (null != top_folders) {
            this.prefService.put(this.getClass(), FOLDERS_PREFS, top_folders);
        }
        if (null != theme) {
            this.prefService.put(this.getClass(), THEME_PREFS, theme);
        }
    }

    public void resetTabSize() {
        this.setTabSize(this.prefService.getInt(this.getClass(), TAB_SIZE_PREFS, 4));
    }

    String getSupportStatus() {
        return this.supportStatus;
    }

    void openLinkInBrowser(String link) {
        try {
            if (!link.startsWith("http")) {
                link = "https://" + link;
            }
            this.platformService.open(new URL(link));
        }
        catch (IOException exc) {
            UIManager.getLookAndFeel().provideErrorFeedback((Component)((Object)this));
            System.out.println(exc.getMessage());
        }
    }

    ErrorParser getErrorHighlighter() {
        return this.errorHighlighter;
    }

    public EditorPaneActions getPaneActions() {
        return this.actions;
    }

    private static class CursorUtils {
        final List<String> SPACE_SEPARATORS = Arrays.asList(" ", "\t", "\f", "\n", "\r");
        final String URL_REGEX = "^((https?|ftp)://|(www|ftp)\\.)?[a-z0-9-]+(\\.[a-z0-9-]+)+([/?].*)?$";
        final Pattern pattern = Pattern.compile("^((https?|ftp)://|(www|ftp)\\.)?[a-z0-9-]+(\\.[a-z0-9-]+)+([/?].*)?$");
        final RTextArea pane;

        private CursorUtils(RTextArea textArea) {
            this.pane = textArea;
        }

        String getLineAtCursor() {
            int start = this.pane.getLineStartOffsetOfCurrentLine();
            int end = this.pane.getLineEndOffsetOfCurrentLine();
            try {
                return this.pane.getDocument().getText(start, end - start);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }

        String getWordAtCursor() {
            String text = this.getLineAtCursor();
            int pos = this.pane.getCaretOffsetFromLineStart();
            int wordStart = this.getWordStart(text, pos);
            int wordEnd = this.getWordEnd(text, pos);
            return text.substring(wordStart, wordEnd);
        }

        String getLinkAtCursor() {
            String text = this.getWordAtCursor();
            if (text == null) {
                return null;
            }
            Matcher m = this.pattern.matcher(text);
            return m.find() ? m.group() : null;
        }

        int getWordStart(String text, int location) {
            int wordStart;
            for (wordStart = location; wordStart > 0 && !this.SPACE_SEPARATORS.contains(text.substring(wordStart - 1, wordStart)); --wordStart) {
            }
            return wordStart;
        }

        int getWordEnd(String text, int location) {
            int wordEnd;
            for (wordEnd = location; wordEnd < text.length() - 1 && !this.SPACE_SEPARATORS.contains(text.substring(wordEnd, wordEnd + 1)); ++wordEnd) {
            }
            return wordEnd;
        }
    }

    class OpenLinkUnderCursor
    extends RecordableTextAction {
        private static final long serialVersionUID = 1L;

        OpenLinkUnderCursor() {
            super("RTA.OpenLinkUnderCursor.Action");
        }

        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            String link = new CursorUtils(textArea).getLinkAtCursor();
            if (link == null) {
                UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
            } else {
                EditorPane.this.openLinkInBrowser(link);
            }
            textArea.requestFocusInWindow();
        }

        public String getMacroID() {
            return this.getName();
        }

        JMenuItem getMenuItem() {
            JMenuItem jmi = new JMenuItem((Action)((Object)this));
            jmi.setText("Open URL Under Cursor");
            return jmi;
        }
    }

    class SearchWebOnSelectedText
    extends RecordableTextAction {
        private static final long serialVersionUID = 1L;

        SearchWebOnSelectedText() {
            super("RTA.SearchWebOnSelectedTextAction");
        }

        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            String selection = textArea.getSelectedText();
            if (selection == null) {
                UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
            } else {
                TextEditor.GuiUtils.runSearchQueryInBrowser((Component)((Object)EditorPane.this), EditorPane.this.platformService, selection.trim());
            }
            textArea.requestFocusInWindow();
        }

        public String getMacroID() {
            return this.getName();
        }

        JMenuItem getMenuItem() {
            JMenuItem jmi = new JMenuItem((Action)((Object)this));
            jmi.setText("Search Web for Selection");
            return jmi;
        }
    }
}

