/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import com.formdev.flatlaf.FlatDarkLaf;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.SwingUtilities;
import org.scijava.Context;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptService;
import org.scijava.ui.swing.script.TextEditor;

public final class Main {
    public static void launch(String language) {
        final Context context = new Context();
        TextEditor editor = new TextEditor(context);
        ScriptService scriptService = (ScriptService)context.getService(ScriptService.class);
        ScriptLanguage lang = scriptService.getLanguageByName(language);
        if (lang == null) {
            throw new IllegalArgumentException("Script language '" + language + "' not found");
        }
        editor.setLanguage(lang);
        editor.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                SwingUtilities.invokeLater(() -> context.dispose());
            }
        });
        editor.setVisible(true);
    }

    public static void main(String[] args) throws Exception {
        FlatDarkLaf.setup();
        String lang = args.length == 0 ? "Java" : args[0];
        Main.launch(lang);
    }
}

