/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script.autocompletion;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.fife.ui.autocomplete.AbstractCompletion;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.scijava.ui.swing.script.autocompletion.ClassUtil;

public class CompletionText {
    private String replacementText;
    private String description;
    private String summary;
    private List<Parameter> method_args = Collections.emptyList();
    private String method_returnType = null;

    public CompletionText(String replacementText) {
        this(replacementText, (String)null, (String)null);
    }

    public CompletionText(String replacementText, String summary, String description) {
        this.replacementText = replacementText;
        this.summary = summary;
        this.description = description;
    }

    public CompletionText(String replacementText, Class<?> c, Field f) {
        this(replacementText, ClassUtil.getSummaryCompletion(f, c), null);
    }

    public CompletionText(String replacementText, Class<?> c, Method m) {
        this(replacementText, ClassUtil.getSummaryCompletion(m, c), null);
        this.method_args = Arrays.asList(m.getParameters());
        this.method_returnType = m.getReturnType().getCanonicalName();
    }

    public CompletionText(String replacementText, Class<?> c, Constructor<?> constructor) {
        this(replacementText, ClassUtil.getSummaryCompletion(constructor, c), null);
        this.method_args = Arrays.asList(constructor.getParameters());
        this.method_returnType = c.getCanonicalName();
    }

    public String getReplacementText() {
        return this.replacementText;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSummary() {
        return this.summary;
    }

    public List<Parameter> getMethodArgs() {
        return this.method_args;
    }

    public String getReturnType() {
        return this.method_returnType;
    }

    public AbstractCompletion getCompletion(CompletionProvider provider, String replacementText) {
        return new BasicCompletion(provider, replacementText, this.description, this.summary);
    }

    public AbstractCompletion getCompletion(CompletionProvider provider, String replacementText, int relevance) {
        BasicCompletion bc = new BasicCompletion(provider, replacementText, this.description, this.summary);
        bc.setRelevance(relevance);
        return bc;
    }

    public void setReplacementText(String replacementText) {
        this.replacementText = replacementText;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String toString() {
        return this.replacementText + " | " + this.description + " | " + this.summary;
    }
}

