/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script.search;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.scijava.Context;
import org.scijava.log.LogService;
import org.scijava.module.ModuleInfo;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.script.ScriptInfo;
import org.scijava.script.ScriptService;
import org.scijava.search.DefaultSearchAction;
import org.scijava.search.SearchAction;
import org.scijava.search.SearchActionFactory;
import org.scijava.search.SearchResult;
import org.scijava.search.module.ModuleSearchResult;
import org.scijava.ui.swing.script.TextEditor;

@Plugin(type=SearchActionFactory.class)
public class ScriptSourceSearchActionFactory
implements SearchActionFactory {
    @Parameter
    private Context context;
    @Parameter
    private LogService log;
    @Parameter
    private ScriptService scriptService;

    public boolean supports(SearchResult result) {
        if (!(result instanceof ModuleSearchResult)) {
            return false;
        }
        ModuleInfo info = ((ModuleSearchResult)result).info();
        return info instanceof ScriptInfo;
    }

    public SearchAction create(SearchResult result) {
        ModuleInfo info = ((ModuleSearchResult)result).info();
        return new DefaultSearchAction("Source", () -> this.openScriptInTextEditor((ScriptInfo)info));
    }

    private void openScriptInTextEditor(ScriptInfo script) {
        StringBuilder sb;
        File scriptFile;
        TextEditor editor;
        block19: {
            editor = new TextEditor(this.context);
            scriptFile = this.getScriptFile(script);
            if (scriptFile.exists()) {
                editor.open(scriptFile);
                editor.setVisible(true);
                return;
            }
            sb = new StringBuilder();
            try (BufferedReader reader = script.getReader();){
                String line;
                if (reader == null) break block19;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                    sb.append("\n");
                }
            }
            catch (IOException exc) {
                this.log.error((Object)("Error reading script: " + script.getPath()), (Throwable)exc);
            }
        }
        if (sb.length() > 0) {
            editor.getEditorPane().setFileName(scriptFile);
            editor.getEditorPane().setText(sb.toString());
        } else {
            String error = "[Cannot load script: " + script.getPath() + "]";
            editor.getEditorPane().setText(error);
        }
        editor.setVisible(true);
    }

    private File getScriptFile(ScriptInfo script) {
        URL scriptURL = script.getURL();
        try {
            if (scriptURL != null) {
                return new File(scriptURL.toURI());
            }
        }
        catch (IllegalArgumentException | URISyntaxException exc) {
            this.log.debug((Throwable)exc);
        }
        File scriptDir = (File)this.scriptService.getScriptDirectories().get(0);
        return new File(scriptDir.getPath() + File.separator + script.getPath());
    }
}

