/*
 * Decompiled with CFR 0.152.
 */
package pal.math;

import pal.math.MersenneTwisterFast;
import pal.math.MultivariateFunction;

public class MathUtils {
    public static MersenneTwisterFast random = new MersenneTwisterFast();

    public static final double[] getNormalized(double[] array) {
        double[] newArray = new double[array.length];
        double total = MathUtils.getTotal(array);
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i] / total;
        }
        return newArray;
    }

    public static final double getTotal(double[] array, int start, int end) {
        double total = 0.0;
        for (int i = start; i < array.length; ++i) {
            total += array[i];
        }
        return total;
    }

    public static final double getTotal(double[] array) {
        return MathUtils.getTotal(array, 0, array.length);
    }

    public static final double[] getRandomArguments(MultivariateFunction mf) {
        double[] values = new double[mf.getNumArguments()];
        for (int i = 0; i < values.length; ++i) {
            double min = mf.getLowerBound(i);
            double max = mf.getUpperBound(i);
            values[i] = (max - min) * MersenneTwisterFast.getNextDouble() + min;
        }
        return values;
    }
}

