/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.viewer.plot.jfreechart;

import java.util.Collection;
import java.util.Iterator;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeriesCollection;
import org.scijava.plot.SeriesStyle;
import org.scijava.plot.XYPlotItem;
import org.scijava.plot.XYSeries;
import org.scijava.ui.swing.viewer.plot.jfreechart.RendererModifier;
import org.scijava.ui.swing.viewer.plot.jfreechart.Utils;

class XYPlotGenerator {
    private final org.scijava.plot.XYPlot xyPlot;
    private final Utils.SortedLabelFactory sortedLabelFactory = new Utils.SortedLabelFactory();
    private final XYPlot jfcPlot = new XYPlot();
    private final XYSeriesCollection jfcDataSet = new XYSeriesCollection();
    private final XYLineAndShapeRenderer jfcRenderer = new XYLineAndShapeRenderer();

    private XYPlotGenerator(org.scijava.plot.XYPlot xyPlot) {
        this.xyPlot = xyPlot;
    }

    public static JFreeChart run(org.scijava.plot.XYPlot xyPlot) {
        return new XYPlotGenerator(xyPlot).getJFreeChart();
    }

    private JFreeChart getJFreeChart() {
        this.jfcPlot.setDataset((XYDataset)this.jfcDataSet);
        this.jfcPlot.setDomainAxis(Utils.getJFreeChartAxis(this.xyPlot.xAxis()));
        this.jfcPlot.setRangeAxis(Utils.getJFreeChartAxis(this.xyPlot.yAxis()));
        this.jfcPlot.setRenderer((XYItemRenderer)this.jfcRenderer);
        this.addAllSeries();
        return Utils.setupJFreeChart(this.xyPlot.getTitle(), (Plot)this.jfcPlot);
    }

    private void addAllSeries() {
        for (XYPlotItem series : this.xyPlot.getItems()) {
            if (!(series instanceof XYSeries)) continue;
            this.addSeries((XYSeries)series);
        }
    }

    private void addSeries(XYSeries series) {
        Utils.SortedLabel uniqueLabel = this.sortedLabelFactory.newLabel(series.getLabel());
        this.addSeriesData(uniqueLabel, series.getXValues(), series.getYValues());
        this.setSeriesStyle(uniqueLabel, series.getStyle(), series.getLegendVisible());
    }

    private void addSeriesData(Utils.SortedLabel uniqueLabel, Collection<Double> xs, Collection<Double> ys) {
        org.jfree.data.xy.XYSeries series = new org.jfree.data.xy.XYSeries((Comparable)uniqueLabel, false, true);
        Iterator<Double> xi = xs.iterator();
        Iterator<Double> yi = ys.iterator();
        while (xi.hasNext() && yi.hasNext()) {
            series.add((Number)xi.next(), (Number)yi.next());
        }
        this.jfcDataSet.addSeries(series);
    }

    private void setSeriesStyle(Utils.SortedLabel label, SeriesStyle style, boolean legendVisible) {
        if (style == null) {
            return;
        }
        int index = this.jfcDataSet.getSeriesIndex((Comparable)label);
        RendererModifier.wrap((AbstractRenderer)this.jfcRenderer).setSeriesStyle(index, style);
        this.jfcRenderer.setSeriesVisibleInLegend(index, Boolean.valueOf(legendVisible));
    }
}

