/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action.window;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JToolBar;

public class ToggleToolBarAction
extends AbstractAction {
    private JToolBar toolBar;
    private PropertyChangeListener propertyHandler = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name.equals("visible")) {
                ToggleToolBarAction.this.putValue("SwingSelectedKey", evt.getNewValue());
            }
        }
    };

    public ToggleToolBarAction(JToolBar toolBar, String label) {
        super(label);
        this.putValue("SwingSelectedKey", true);
        this.setToolBar(toolBar);
    }

    @Override
    public void putValue(String key, Object newValue) {
        super.putValue(key, newValue);
        if (key == "SwingSelectedKey" && this.toolBar != null) {
            this.toolBar.setVisible((Boolean)newValue);
        }
    }

    public void setToolBar(JToolBar newValue) {
        if (this.toolBar != null) {
            this.toolBar.removePropertyChangeListener(this.propertyHandler);
        }
        this.toolBar = newValue;
        if (this.toolBar != null) {
            this.toolBar.addPropertyChangeListener(this.propertyHandler);
            this.putValue("SwingSelectedKey", this.toolBar.isVisible());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.toolBar != null) {
            this.putValue("SwingSelectedKey", !this.toolBar.isVisible());
        }
    }
}

