/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.beans;

import java.lang.reflect.Method;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.UndoableEdit;

public class PropertyChangeEdit
extends AbstractUndoableEdit {
    private Object source;
    private String propertyName;
    private Object oldValue;
    private Object newValue;
    private Class type;
    private String presentationName;

    public <T> PropertyChangeEdit(Object source, String propertyName, Class<T> type, T oldValue, T newValue) {
        this.source = source;
        this.propertyName = this.presentationName = propertyName;
        this.type = type;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public PropertyChangeEdit(Object source, String propertyName, boolean oldValue, boolean newValue) {
        this(source, propertyName, Boolean.TYPE, oldValue, newValue);
    }

    public PropertyChangeEdit(Object source, String propertyName, int oldValue, int newValue) {
        this(source, propertyName, Integer.TYPE, oldValue, newValue);
    }

    public PropertyChangeEdit(Object source, String propertyName, long oldValue, long newValue) {
        this(source, propertyName, Long.TYPE, oldValue, newValue);
    }

    public PropertyChangeEdit(Object source, String propertyName, float oldValue, float newValue) {
        this(source, propertyName, Float.TYPE, Float.valueOf(oldValue), Float.valueOf(newValue));
    }

    public PropertyChangeEdit(Object source, String propertyName, double oldValue, double newValue) {
        this(source, propertyName, Double.TYPE, oldValue, newValue);
    }

    public PropertyChangeEdit(Object source, String propertyName, char oldValue, char newValue) {
        this(source, propertyName, Character.TYPE, Character.valueOf(oldValue), Character.valueOf(newValue));
    }

    public PropertyChangeEdit(Object source, String propertyName, String oldValue, String newValue) {
        this(source, propertyName, String.class, oldValue, newValue);
    }

    protected Method getSetter() {
        try {
            return this.source.getClass().getMethod("set" + Character.toUpperCase(this.propertyName.charAt(0)) + this.propertyName.substring(1), this.type);
        }
        catch (Exception e) {
            InternalError ie = new InternalError("Couldn't find setter for property \"" + this.propertyName + "\" in " + this.source);
            ie.initCause(e);
            throw ie;
        }
    }

    @Override
    public void undo() throws CannotRedoException {
        super.undo();
        try {
            this.getSetter().invoke(this.source, this.oldValue);
        }
        catch (Exception e) {
            InternalError ie = new InternalError("Couldn't invoke setter for property \"" + this.propertyName + "\" in " + this.source);
            ie.initCause(e);
            throw ie;
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        try {
            this.getSetter().invoke(this.source, this.newValue);
        }
        catch (Exception e) {
            InternalError ie = new InternalError("Couldn't invoke setter for property \"" + this.propertyName + "\" in " + this.source);
            ie.initCause(e);
            throw ie;
        }
    }

    @Override
    public String getPresentationName() {
        return this.presentationName;
    }

    public void setPresentationName(String presentationName) {
        this.presentationName = presentationName;
    }

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        if (anEdit instanceof PropertyChangeEdit) {
            PropertyChangeEdit that = (PropertyChangeEdit)anEdit;
            if (that.source == this.source && that.propertyName.equals(this.propertyName)) {
                this.newValue = that.newValue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + " [" + this.propertyName + "," + this.oldValue + "," + this.newValue + "]";
    }
}

