/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import java.awt.color.ColorSpace;
import org.jhotdraw.color.NamedColorSpace;

public class CIELABColorSpace
extends ColorSpace
implements NamedColorSpace {
    private static final double[] D65 = new double[]{0.9505, 1.0, 1.089};
    private double Xw;
    private double Yw;
    private double Zw;
    private static final double eps = 0.008856451679035631;
    private static final double k = 903.2962962962963;
    private static final ColorSpace sRGB = ColorSpace.getInstance(1000);
    private OutsideGamutHandling outsideGamutHandling = OutsideGamutHandling.CLAMP;

    public CIELABColorSpace() {
        super(1, 3);
        this.Xw = D65[0];
        this.Yw = D65[1];
        this.Zw = D65[2];
    }

    @Override
    public float[] toRGB(float[] colorvalue) {
        float[] ciexyz = this.toCIEXYZ(colorvalue);
        double X = ciexyz[0];
        double Y = ciexyz[1];
        double Z = ciexyz[2];
        double Rs = 3.241 * X + -1.5374 * Y + -0.4986 * Z;
        double Gs = -0.9692 * X + 1.876 * Y + -0.0416 * Z;
        double Bs = 0.0556 * X + -0.204 * Y + 1.057 * Z;
        Rs = Rs <= 0.00304 ? 12.92 * Rs : 1.055 * Math.pow(Rs, 0.4166666666666667) - 0.055;
        Gs = Gs <= 0.00304 ? 12.92 * Gs : 1.055 * Math.pow(Gs, 0.4166666666666667) - 0.055;
        Bs = Bs <= 0.00304 ? 12.92 * Bs : 1.055 * Math.pow(Bs, 0.4166666666666667) - 0.055;
        switch (this.outsideGamutHandling) {
            case CLAMP: {
                Rs = Math.min(1.0, Math.max(0.0, Rs));
                Gs = Math.min(1.0, Math.max(0.0, Gs));
                Bs = Math.min(1.0, Math.max(0.0, Bs));
            }
        }
        return new float[]{(float)Rs, (float)Gs, (float)Bs};
    }

    @Override
    public float[] fromRGB(float[] rgbvalue) {
        float[] ciexyz = sRGB.fromRGB(rgbvalue);
        return this.fromCIEXYZ(ciexyz);
    }

    @Override
    public float[] toCIEXYZ(float[] colorvalue) {
        double yr;
        double L = colorvalue[0];
        double a = colorvalue[1];
        double b = colorvalue[2];
        double fy = (L + 16.0) / 116.0;
        double fx = a / 500.0 + fy;
        double fz = fy - b / 200.0;
        double fxp3 = fx * fx * fx;
        double xr = fxp3 > 0.008856451679035631 ? fxp3 : (116.0 * fx - 16.0) / 903.2962962962963;
        if (L > 8.0) {
            yr = (L + 16.0) / 116.0;
            yr = yr * yr * yr;
        } else {
            yr = L / 903.2962962962963;
        }
        double fzp3 = fz * fz * fz;
        double zr = fzp3 > 0.008856451679035631 ? fzp3 : (116.0 * fz - 16.0) / 903.2962962962963;
        double X = xr * this.Xw;
        double Y = yr * this.Yw;
        double Z = zr * this.Zw;
        return new float[]{(float)X, (float)Y, (float)Z};
    }

    @Override
    public float[] fromCIEXYZ(float[] colorvalue) {
        double X = colorvalue[0];
        double Y = colorvalue[1];
        double Z = colorvalue[2];
        double xr = X / this.Xw;
        double yr = Y / this.Yw;
        double zr = Z / this.Zw;
        double fx = xr > 0.008856451679035631 ? Math.pow(xr, 0.3333333333333333) : (903.2962962962963 * xr + 16.0) / 116.0;
        double fy = yr > 0.008856451679035631 ? Math.pow(yr, 0.3333333333333333) : (903.2962962962963 * yr + 16.0) / 116.0;
        double fz = zr > 0.008856451679035631 ? Math.pow(zr, 0.3333333333333333) : (903.2962962962963 * zr + 16.0) / 116.0;
        double L = 116.0 * fy - 16.0;
        double a = 500.0 * (fx - fy);
        double b = 200.0 * (fy - fz);
        return new float[]{(float)L, (float)a, (float)b};
    }

    @Override
    public String getName() {
        return "CIE 1976 L*a*b*";
    }

    @Override
    public float getMinValue(int component) {
        switch (component) {
            case 0: {
                return 0.0f;
            }
            case 1: 
            case 2: {
                return -128.0f;
            }
        }
        throw new IllegalArgumentException("Illegal component:" + component);
    }

    @Override
    public float getMaxValue(int component) {
        switch (component) {
            case 0: {
                return 100.0f;
            }
            case 1: 
            case 2: {
                return 127.0f;
            }
        }
        throw new IllegalArgumentException("Illegal component:" + component);
    }

    @Override
    public String getName(int component) {
        switch (component) {
            case 0: {
                return "L*";
            }
            case 1: {
                return "a*";
            }
            case 2: {
                return "b*";
            }
        }
        throw new IllegalArgumentException("Illegal component:" + component);
    }

    public void setOutsideGamutHandling(OutsideGamutHandling b) {
        this.outsideGamutHandling = b;
    }

    public OutsideGamutHandling getOutsideGamutHandling() {
        return this.outsideGamutHandling;
    }

    public static void main(String[] arg) {
        CIELABColorSpace cs = new CIELABColorSpace();
        float[] lab = cs.fromRGB(new float[]{1.0f, 1.0f, 1.0f});
        System.out.println("rgb->lab:" + lab[0] + "," + lab[1] + "," + lab[2]);
        float[] xyz = cs.toCIEXYZ(new float[]{0.75f, 0.25f, 0.1f});
        System.out.println("    lab->xyz:" + xyz[0] + "," + xyz[1] + "," + xyz[2]);
        lab = cs.fromCIEXYZ(xyz);
        System.out.println("R xyz->LCHab:" + lab[0] + "," + lab[1] + "," + lab[2]);
        lab = cs.fromCIEXYZ(new float[]{1.0f, 1.0f, 1.0f});
        System.out.println("xyz->lab:" + lab[0] + "," + lab[1] + "," + lab[2]);
        lab = cs.fromCIEXYZ(new float[]{0.5f, 1.0f, 1.0f});
        System.out.println("xyz->lab:" + lab[0] + "," + lab[1] + "," + lab[2]);
    }

    public static enum OutsideGamutHandling {
        CLAMP,
        LEAVE_OUTSIDE;

    }
}

