/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import java.awt.Color;
import org.jhotdraw.color.AbstractHarmonicRule;
import org.jhotdraw.color.HarmonicColorModel;

public class SimpleHarmonicRule
extends AbstractHarmonicRule {
    private float difference;
    private int componentIndex;

    public SimpleHarmonicRule(int componentIndex, float difference, int baseIndex, int ... derivedIndices) {
        this.componentIndex = componentIndex;
        this.difference = difference;
        this.baseIndex = baseIndex;
        this.derivedIndices = derivedIndices;
    }

    public void setConstraint(float constraint) {
        this.difference = constraint;
    }

    public float getConstraint(float constraint) {
        return constraint;
    }

    public void setComponentIndex(int newValue) {
        this.componentIndex = newValue;
    }

    public int getComponentIndex() {
        return this.componentIndex;
    }

    @Override
    public void apply(HarmonicColorModel model) {
        Color baseColor;
        if (this.derivedIndices != null && (baseColor = model.get(this.getBaseIndex())) != null) {
            float[] derivedComponents = null;
            for (int i = 0; i < this.derivedIndices.length; ++i) {
                derivedComponents = baseColor.getComponents(derivedComponents);
                int n = this.componentIndex;
                derivedComponents[n] = derivedComponents[n] + this.difference * (float)(i + 1);
                model.set(this.derivedIndices[i], new Color(model.getColorSpace(), derivedComponents, 1.0f));
            }
        }
    }

    @Override
    public void colorChanged(HarmonicColorModel model, int index, Color oldValue, Color newValue) {
    }
}

