/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jhotdraw.app.action.edit.CopyAction;
import org.jhotdraw.app.action.edit.CutAction;
import org.jhotdraw.app.action.edit.DeleteAction;
import org.jhotdraw.app.action.edit.PasteAction;
import org.jhotdraw.app.action.edit.SelectAllAction;
import org.jhotdraw.beans.AbstractBean;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.action.IncreaseHandleDetailLevelAction;
import org.jhotdraw.draw.action.MoveAction;
import org.jhotdraw.draw.action.MoveConstrainedAction;
import org.jhotdraw.draw.event.ToolAdapter;
import org.jhotdraw.draw.event.ToolEvent;
import org.jhotdraw.draw.tool.Tool;

public class DefaultDrawingEditor
extends AbstractBean
implements DrawingEditor {
    private HashMap<AttributeKey, Object> defaultAttributes = new HashMap();
    private HashMap<AttributeKey, Object> handleAttributes = new HashMap();
    private Tool tool;
    private HashSet<DrawingView> views;
    private DrawingView activeView;
    private boolean isEnabled = true;
    private ToolHandler toolHandler;
    private InputMap inputMap;
    private ActionMap actionMap;
    private FocusListener focusHandler = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
            DefaultDrawingEditor.this.setActiveView(DefaultDrawingEditor.this.findView((Container)e.getSource()));
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    };

    public DefaultDrawingEditor() {
        this.toolHandler = new ToolHandler();
        this.setDefaultAttribute((AttributeKey)AttributeKeys.FILL_COLOR, Color.white);
        this.setDefaultAttribute((AttributeKey)AttributeKeys.STROKE_COLOR, Color.black);
        this.setDefaultAttribute((AttributeKey)AttributeKeys.TEXT_COLOR, Color.black);
        this.views = new HashSet();
        this.inputMap = this.createInputMap();
        this.actionMap = this.createActionMap();
    }

    @Override
    public void setTool(Tool newValue) {
        Tool oldValue = this.tool;
        if (newValue == this.tool) {
            return;
        }
        if (this.tool != null) {
            for (DrawingView v : this.views) {
                v.removeMouseListener(this.tool);
                v.removeMouseMotionListener(this.tool);
                v.removeKeyListener(this.tool);
            }
            this.tool.deactivate(this);
            this.tool.removeToolListener(this.toolHandler);
        }
        this.tool = newValue;
        if (this.tool != null) {
            this.tool.activate(this);
            for (DrawingView v : this.views) {
                v.addMouseListener(this.tool);
                v.addMouseMotionListener(this.tool);
                v.addKeyListener(this.tool);
            }
            this.tool.addToolListener(this.toolHandler);
        }
        this.firePropertyChange("tool", oldValue, newValue);
    }

    @Override
    public void setActiveView(DrawingView newValue) {
        DrawingView oldValue = this.activeView;
        this.activeView = newValue;
        this.firePropertyChange("activeView", oldValue, newValue);
    }

    @Override
    public Tool getTool() {
        return this.tool;
    }

    @Override
    public DrawingView getActiveView() {
        return this.activeView;
    }

    private void updateActiveView() {
        DrawingView aView = null;
        for (DrawingView v : this.views) {
            if (v.getComponent().isFocusOwner()) {
                this.setActiveView(v);
                return;
            }
            aView = v;
        }
        this.setActiveView(aView);
    }

    @Override
    public void applyDefaultAttributesTo(Figure f) {
        for (Map.Entry<AttributeKey, Object> entry : this.defaultAttributes.entrySet()) {
            f.set(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public <T> T getDefaultAttribute(AttributeKey<T> key) {
        if (this.defaultAttributes.containsKey(key)) {
            return key.get(this.defaultAttributes);
        }
        return key.getDefaultValue();
    }

    public void setDefaultAttribute(AttributeKey key, Object newValue) {
        Object oldValue = this.defaultAttributes.put(key, newValue);
        this.firePropertyChange("defaultAttribute." + key.getKey(), oldValue, newValue);
    }

    @Override
    public void remove(DrawingView view) {
        view.getComponent().removeFocusListener(this.focusHandler);
        this.views.remove(view);
        if (this.tool != null) {
            view.removeMouseListener(this.tool);
            view.removeMouseMotionListener(this.tool);
            view.removeKeyListener(this.tool);
        }
        view.removeNotify(this);
        if (this.activeView == view) {
            view = this.views.size() > 0 ? this.views.iterator().next() : null;
        }
        this.updateActiveView();
    }

    @Override
    public void add(DrawingView view) {
        this.views.add(view);
        view.addNotify(this);
        view.getComponent().addFocusListener(this.focusHandler);
        if (this.tool != null) {
            view.addMouseListener(this.tool);
            view.addMouseMotionListener(this.tool);
            view.addKeyListener(this.tool);
        }
        this.updateActiveView();
    }

    @Override
    public void setCursor(Cursor c) {
    }

    @Override
    public Collection<DrawingView> getDrawingViews() {
        return Collections.unmodifiableCollection(this.views);
    }

    @Override
    public DrawingView findView(Container c) {
        for (DrawingView v : this.views) {
            if (v.getComponent() != c) continue;
            return v;
        }
        return null;
    }

    @Override
    public void setEnabled(boolean newValue) {
        if (newValue != this.isEnabled) {
            boolean oldValue = this.isEnabled;
            this.isEnabled = newValue;
            this.firePropertyChange("enabled", oldValue, newValue);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public Map<AttributeKey, Object> getDefaultAttributes() {
        return Collections.unmodifiableMap(this.defaultAttributes);
    }

    public void setHandleAttribute(AttributeKey key, Object value) {
        this.handleAttributes.put(key, value);
    }

    @Override
    public <T> T getHandleAttribute(AttributeKey<T> key) {
        if (this.handleAttributes.containsKey(key)) {
            return key.get(this.handleAttributes);
        }
        return key.getDefaultValue();
    }

    @Override
    public void setInputMap(InputMap newValue) {
        InputMap oldValue = this.inputMap;
        this.inputMap = newValue;
        this.firePropertyChange("inputMap", oldValue, newValue);
    }

    @Override
    public InputMap getInputMap() {
        return this.inputMap;
    }

    @Override
    public void setActionMap(ActionMap newValue) {
        ActionMap oldValue = this.actionMap;
        this.actionMap = newValue;
        this.firePropertyChange("actionMap", oldValue, newValue);
    }

    @Override
    public ActionMap getActionMap() {
        return this.actionMap;
    }

    protected InputMap createInputMap() {
        InputMap m = new InputMap();
        m.put(KeyStroke.getKeyStroke(127, 0), "edit.delete");
        m.put(KeyStroke.getKeyStroke(8, 0), "edit.delete");
        m.put(KeyStroke.getKeyStroke(65, 0), "edit.selectAll");
        m.put(KeyStroke.getKeyStroke(65, 128), "edit.selectAll");
        m.put(KeyStroke.getKeyStroke(65, 256), "edit.selectAll");
        m.put(KeyStroke.getKeyStroke(32, 0), "view.increaseHandleDetailLevel");
        m.put(KeyStroke.getKeyStroke(37, 0), "edit.moveConstrainedWest");
        m.put(KeyStroke.getKeyStroke(39, 0), "edit.moveConstrainedEast");
        m.put(KeyStroke.getKeyStroke(38, 0), "edit.moveConstrainedNorth");
        m.put(KeyStroke.getKeyStroke(40, 0), "edit.moveConstrainedSouth");
        m.put(KeyStroke.getKeyStroke(37, 512), "edit.moveWest");
        m.put(KeyStroke.getKeyStroke(39, 512), "edit.moveEast");
        m.put(KeyStroke.getKeyStroke(38, 512), "edit.moveNorth");
        m.put(KeyStroke.getKeyStroke(40, 512), "edit.moveSouth");
        m.put(KeyStroke.getKeyStroke(37, 64), "edit.moveWest");
        m.put(KeyStroke.getKeyStroke(39, 64), "edit.moveEast");
        m.put(KeyStroke.getKeyStroke(38, 64), "edit.moveNorth");
        m.put(KeyStroke.getKeyStroke(40, 64), "edit.moveSouth");
        m.put(KeyStroke.getKeyStroke(37, 128), "edit.moveWest");
        m.put(KeyStroke.getKeyStroke(39, 128), "edit.moveEast");
        m.put(KeyStroke.getKeyStroke(38, 128), "edit.moveNorth");
        m.put(KeyStroke.getKeyStroke(40, 128), "edit.moveSouth");
        m.put(KeyStroke.getKeyStroke(67, 128), "edit.copy");
        m.put(KeyStroke.getKeyStroke(67, 256), "edit.copy");
        m.put(KeyStroke.getKeyStroke(86, 128), "edit.paste");
        m.put(KeyStroke.getKeyStroke(86, 256), "edit.paste");
        m.put(KeyStroke.getKeyStroke(88, 128), "edit.cut");
        m.put(KeyStroke.getKeyStroke(88, 256), "edit.cut");
        return m;
    }

    protected ActionMap createActionMap() {
        ActionMap m = new ActionMap();
        m.put("edit.delete", new DeleteAction());
        m.put("edit.selectAll", new SelectAllAction());
        m.put("view.increaseHandleDetailLevel", new IncreaseHandleDetailLevelAction(this));
        m.put("edit.moveEast", new MoveAction.East(this));
        m.put("edit.moveWest", new MoveAction.West(this));
        m.put("edit.moveNorth", new MoveAction.North(this));
        m.put("edit.moveSouth", new MoveAction.South(this));
        m.put("edit.moveConstrainedEast", new MoveConstrainedAction.East(this));
        m.put("edit.moveConstrainedWest", new MoveConstrainedAction.West(this));
        m.put("edit.moveConstrainedNorth", new MoveConstrainedAction.North(this));
        m.put("edit.moveConstrainedSouth", new MoveConstrainedAction.South(this));
        m.put("edit.cut", new CutAction());
        m.put("edit.copy", new CopyAction());
        m.put("edit.paste", new PasteAction());
        return m;
    }

    private class ToolHandler
    extends ToolAdapter {
        private ToolHandler() {
        }

        @Override
        public void areaInvalidated(ToolEvent evt) {
            Rectangle r = evt.getInvalidatedArea();
            evt.getView().getComponent().repaint(r.x, r.y, r.width, r.height);
        }

        @Override
        public void toolStarted(ToolEvent evt) {
            DefaultDrawingEditor.this.setActiveView(evt.getView());
        }

        @Override
        public void boundsInvalidated(ToolEvent evt) {
            Drawing d = evt.getView().getDrawing();
            for (DrawingView v : DefaultDrawingEditor.this.views) {
                if (v.getDrawing() != d) continue;
                JComponent c = v.getComponent();
                c.revalidate();
            }
        }
    }
}

