/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jhotdraw.draw.AbstractCompositeFigure;
import org.jhotdraw.draw.AbstractDrawing;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureLayerComparator;
import org.jhotdraw.draw.event.FigureEvent;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.QuadTree;
import org.jhotdraw.util.ReversedList;

public class QuadTreeDrawing
extends AbstractDrawing {
    private QuadTree<Figure> quadTree = new QuadTree();
    private boolean needsSorting = false;

    @Override
    public int indexOf(Figure figure) {
        return this.children.indexOf(figure);
    }

    @Override
    public void basicAdd(int index, Figure figure) {
        super.basicAdd(index, figure);
        this.quadTree.add(figure, figure.getDrawingArea());
        this.needsSorting = true;
    }

    @Override
    public Figure basicRemoveChild(int index) {
        Figure figure = this.getChild(index);
        this.quadTree.remove(figure);
        this.needsSorting = true;
        super.basicRemoveChild(index);
        return figure;
    }

    @Override
    public void draw(Graphics2D g) {
        Rectangle clipBounds = g.getClipBounds();
        if (clipBounds != null) {
            Collection<Figure> c = this.quadTree.findIntersects(clipBounds);
            List<Figure> toDraw = this.sort(c);
            this.draw(g, toDraw);
        } else {
            this.draw(g, this.children);
        }
    }

    @Override
    public List<Figure> sort(Collection<? extends Figure> c) {
        this.ensureSorted();
        ArrayList<Figure> sorted = new ArrayList<Figure>(c.size());
        for (Figure f : this.children) {
            if (!c.contains(f)) continue;
            sorted.add(f);
        }
        return sorted;
    }

    public void draw(Graphics2D g, Collection<Figure> c) {
        for (Figure f : c) {
            if (!f.isVisible()) continue;
            f.draw(g);
        }
    }

    public List<Figure> getChildren(Rectangle2D.Double bounds) {
        return new LinkedList<Figure>(this.quadTree.findInside(bounds));
    }

    @Override
    public List<Figure> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public Figure findFigureInside(Point2D.Double p) {
        Collection<Figure> c = this.quadTree.findContains(p);
        for (Figure f : this.getFiguresFrontToBack()) {
            if (!c.contains(f) || !f.contains(p)) continue;
            return f.findFigureInside(p);
        }
        return null;
    }

    @Override
    public List<Figure> getFiguresFrontToBack() {
        this.ensureSorted();
        return new ReversedList<Figure>(this.children);
    }

    @Override
    public Figure findFigure(Point2D.Double p) {
        Collection<Figure> c = this.quadTree.findContains(p);
        switch (c.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Figure f = c.iterator().next();
                return f.contains(p) ? f : null;
            }
        }
        for (Figure f : this.getFiguresFrontToBack()) {
            if (!c.contains(f) || !f.contains(p)) continue;
            return f;
        }
        return null;
    }

    @Override
    public Figure findFigureExcept(Point2D.Double p, Figure ignore) {
        Collection<Figure> c = this.quadTree.findContains(p);
        switch (c.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Figure f = c.iterator().next();
                return f == ignore || !f.contains(p) ? null : f;
            }
        }
        for (Figure f : this.getFiguresFrontToBack()) {
            if (f == ignore || !f.contains(p)) continue;
            return f;
        }
        return null;
    }

    @Override
    public Figure findFigureExcept(Point2D.Double p, Collection<? extends Figure> ignore) {
        Collection<Figure> c = this.quadTree.findContains(p);
        switch (c.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Figure f = c.iterator().next();
                return !ignore.contains(f) || !f.contains(p) ? null : f;
            }
        }
        for (Figure f : this.getFiguresFrontToBack()) {
            if (ignore.contains(f) || !f.contains(p)) continue;
            return f;
        }
        return null;
    }

    @Override
    public Figure findFigureBehind(Point2D.Double p, Figure figure) {
        boolean isBehind = false;
        for (Figure f : this.getFiguresFrontToBack()) {
            if (isBehind) {
                if (!f.isVisible() || !f.contains(p)) continue;
                return f;
            }
            isBehind = figure == f;
        }
        return null;
    }

    @Override
    public Figure findFigureBehind(Point2D.Double p, Collection<? extends Figure> children) {
        int inFrontOf = children.size();
        for (Figure f : this.getFiguresFrontToBack()) {
            if (inFrontOf == 0) {
                if (!f.isVisible() || !f.contains(p)) continue;
                return f;
            }
            if (!children.contains(f)) continue;
            --inFrontOf;
        }
        return null;
    }

    @Override
    public List<Figure> findFigures(Rectangle2D.Double r) {
        LinkedList<Figure> c = new LinkedList<Figure>(this.quadTree.findIntersects(r));
        switch (c.size()) {
            case 0: 
            case 1: {
                return c;
            }
        }
        return this.sort(c);
    }

    @Override
    public List<Figure> findFiguresWithin(Rectangle2D.Double bounds) {
        LinkedList<Figure> contained = new LinkedList<Figure>();
        for (Figure f : this.children) {
            Rectangle2D.Double r = f.getBounds();
            if (f.get(AttributeKeys.TRANSFORM) != null) {
                Rectangle2D rt = f.get(AttributeKeys.TRANSFORM).createTransformedShape(r).getBounds2D();
                Rectangle2D.Double double_ = r = rt instanceof Rectangle2D.Double ? (Rectangle2D.Double)rt : new Rectangle2D.Double(rt.getX(), rt.getY(), rt.getWidth(), rt.getHeight());
            }
            if (!f.isVisible() || !Geom.contains(bounds, r)) continue;
            contained.add(f);
        }
        return contained;
    }

    @Override
    public void bringToFront(Figure figure) {
        if (this.children.remove(figure)) {
            this.children.add(figure);
            this.needsSorting = true;
            this.fireAreaInvalidated(figure.getDrawingArea());
        }
    }

    @Override
    public void sendToBack(Figure figure) {
        if (this.children.remove(figure)) {
            this.children.add(0, figure);
            this.needsSorting = true;
            this.fireAreaInvalidated(figure.getDrawingArea());
        }
    }

    @Override
    public boolean contains(Figure f) {
        return this.children.contains(f);
    }

    private void ensureSorted() {
        if (this.needsSorting) {
            Collections.sort(this.children, FigureLayerComparator.INSTANCE);
            this.needsSorting = false;
        }
    }

    protected void setAttributeOnChildren(AttributeKey key, Object newValue) {
    }

    @Override
    public QuadTreeDrawing clone() {
        QuadTreeDrawing that = (QuadTreeDrawing)super.clone();
        that.quadTree = new QuadTree();
        for (Figure f : this.getChildren()) {
            this.quadTree.add(f, f.getDrawingArea());
        }
        return that;
    }

    @Override
    protected AbstractCompositeFigure.EventHandler createEventHandler() {
        return new QuadTreeEventHandler();
    }

    @Override
    protected void drawFill(Graphics2D g) {
    }

    @Override
    protected void drawStroke(Graphics2D g) {
    }

    @Override
    public void drawCanvas(Graphics2D g) {
        if (this.get(AttributeKeys.CANVAS_WIDTH) != null && this.get(AttributeKeys.CANVAS_HEIGHT) != null) {
            Color canvasColor = this.get(AttributeKeys.CANVAS_FILL_COLOR);
            Double fillOpacity = this.get(AttributeKeys.CANVAS_FILL_OPACITY);
            if (canvasColor != null && fillOpacity > 0.0) {
                canvasColor = new Color(canvasColor.getRGB() & 0xFFFFFF | (int)(fillOpacity * 255.0) << 24, true);
                Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, this.get(AttributeKeys.CANVAS_WIDTH), this.get(AttributeKeys.CANVAS_HEIGHT));
                g.setColor(canvasColor);
                g.fill(r);
            }
        }
    }

    protected class QuadTreeEventHandler
    extends AbstractCompositeFigure.EventHandler {
        protected QuadTreeEventHandler() {
        }

        @Override
        public void figureChanged(FigureEvent e) {
            if (!QuadTreeDrawing.this.isChanging()) {
                QuadTreeDrawing.this.quadTree.remove(e.getFigure());
                QuadTreeDrawing.this.quadTree.add(e.getFigure(), e.getFigure().getDrawingArea());
                QuadTreeDrawing.this.needsSorting = true;
                QuadTreeDrawing.this.invalidate();
                QuadTreeDrawing.this.fireAreaInvalidated(e.getInvalidatedArea());
            }
        }
    }
}

