/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.jhotdraw.draw.AbstractAttributedFigure;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.connector.ChopRoundRectangleConnector;
import org.jhotdraw.draw.connector.Connector;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.handle.RoundRectangleRadiusHandle;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class RoundRectangleFigure
extends AbstractAttributedFigure {
    public static final String ARC_WIDTH_PROPERTY = "arcWidth";
    public static final String ARC_HEIGHT_PROPERTY = "arcHeight";
    protected RoundRectangle2D.Double roundrect;
    protected static final double DEFAULT_ARC = 20.0;

    public RoundRectangleFigure() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public RoundRectangleFigure(double x, double y, double width, double height) {
        this.roundrect = new RoundRectangle2D.Double(x, y, width, height, 20.0, 20.0);
    }

    @Override
    protected void drawFill(Graphics2D g) {
        RoundRectangle2D.Double r = (RoundRectangle2D.Double)this.roundrect.clone();
        double grow = AttributeKeys.getPerpendicularFillGrowth(this);
        r.x -= grow;
        r.y -= grow;
        r.width += grow * 2.0;
        r.height += grow * 2.0;
        r.arcwidth += grow * 2.0;
        r.archeight += grow * 2.0;
        if (r.width > 0.0 && r.height > 0.0) {
            g.fill(r);
        }
    }

    @Override
    protected void drawStroke(Graphics2D g) {
        RoundRectangle2D.Double r = (RoundRectangle2D.Double)this.roundrect.clone();
        double grow = AttributeKeys.getPerpendicularDrawGrowth(this);
        r.x -= grow;
        r.y -= grow;
        r.width += grow * 2.0;
        r.height += grow * 2.0;
        r.arcwidth += grow * 2.0;
        r.archeight += grow * 2.0;
        if (r.width > 0.0 && r.height > 0.0) {
            g.draw(r);
        }
    }

    @Override
    public Rectangle2D.Double getBounds() {
        return (Rectangle2D.Double)this.roundrect.getBounds2D();
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double r = (Rectangle2D.Double)this.roundrect.getBounds2D();
        double grow = AttributeKeys.getPerpendicularHitGrowth(this) + 1.0;
        Geom.grow(r, grow, grow);
        return r;
    }

    public double getArcWidth() {
        return this.roundrect.arcwidth;
    }

    public double getArcHeight() {
        return this.roundrect.archeight;
    }

    public void setArcWidth(double newValue) {
        double oldValue = this.roundrect.arcwidth;
        this.roundrect.arcwidth = newValue;
        this.firePropertyChange(ARC_WIDTH_PROPERTY, oldValue, newValue);
    }

    public void setArcHeight(double newValue) {
        double oldValue = this.roundrect.archeight;
        this.roundrect.archeight = newValue;
        this.firePropertyChange(ARC_HEIGHT_PROPERTY, oldValue, newValue);
    }

    public void setArc(double width, double height) {
        this.setArcWidth(width);
        this.setArcHeight(height);
    }

    @Override
    public boolean contains(Point2D.Double p) {
        RoundRectangle2D.Double r = (RoundRectangle2D.Double)this.roundrect.clone();
        double grow = AttributeKeys.getPerpendicularHitGrowth(this);
        r.x -= grow;
        r.y -= grow;
        r.width += grow * 2.0;
        r.height += grow * 2.0;
        r.arcwidth += grow * 2.0;
        r.archeight += grow * 2.0;
        return r.contains(p);
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        this.roundrect.x = Math.min(anchor.x, lead.x);
        this.roundrect.y = Math.min(anchor.y, lead.y);
        this.roundrect.width = Math.max(0.1, Math.abs(lead.x - anchor.x));
        this.roundrect.height = Math.max(0.1, Math.abs(lead.y - anchor.y));
    }

    @Override
    public void transform(AffineTransform tx) {
        Point2D.Double anchor = this.getStartPoint();
        Point2D.Double lead = this.getEndPoint();
        this.setBounds((Point2D.Double)tx.transform(anchor, anchor), (Point2D.Double)tx.transform(lead, lead));
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList handles = (LinkedList)super.createHandles(detailLevel);
        handles.add(new RoundRectangleRadiusHandle(this));
        return handles;
    }

    @Override
    public void restoreTransformTo(Object geometry) {
        RoundRectangle2D.Double r = (RoundRectangle2D.Double)geometry;
        this.roundrect.x = r.x;
        this.roundrect.y = r.y;
        this.roundrect.width = r.width;
        this.roundrect.height = r.height;
    }

    @Override
    public Object getTransformRestoreData() {
        return this.roundrect.clone();
    }

    @Override
    public Connector findConnector(Point2D.Double p, ConnectionFigure prototype) {
        return new ChopRoundRectangleConnector(this);
    }

    @Override
    public Connector findCompatibleConnector(Connector c, boolean isStartConnector) {
        return new ChopRoundRectangleConnector(this);
    }

    @Override
    public RoundRectangleFigure clone() {
        RoundRectangleFigure that = (RoundRectangleFigure)super.clone();
        that.roundrect = (RoundRectangle2D.Double)this.roundrect.clone();
        return that;
    }

    @Override
    public void read(DOMInput in) throws IOException {
        super.read(in);
        this.roundrect.arcwidth = in.getAttribute(ARC_WIDTH_PROPERTY, 20.0);
        this.roundrect.archeight = in.getAttribute(ARC_HEIGHT_PROPERTY, 20.0);
    }

    @Override
    public void write(DOMOutput out) throws IOException {
        super.write(out);
        out.addAttribute(ARC_WIDTH_PROPERTY, this.roundrect.arcwidth);
        out.addAttribute(ARC_HEIGHT_PROPERTY, this.roundrect.archeight);
    }
}

