/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.connector;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.connector.AbstractConnector;
import org.jhotdraw.draw.locator.Locator;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class LocatorConnector
extends AbstractConnector {
    public static final int SIZE = 2;
    private Locator locator;

    public LocatorConnector() {
    }

    public LocatorConnector(Figure owner, Locator l) {
        super(owner);
        this.locator = l;
    }

    public Locator getLocator() {
        return this.locator;
    }

    protected Point2D.Double locate(ConnectionFigure connection) {
        return this.locator.locate(this.getOwner());
    }

    @Override
    public boolean contains(Point2D.Double p) {
        return this.getBounds().contains(p);
    }

    @Override
    public Rectangle2D.Double getBounds() {
        Point2D.Double p = this.locator.locate(this.getOwner());
        return new Rectangle2D.Double(p.x - 1.0, p.y - 1.0, 2.0, 2.0);
    }

    @Override
    public void read(DOMInput in) throws IOException {
        super.read(in);
        in.openElement("locator");
        this.locator = (Locator)in.readObject(0);
        in.closeElement();
    }

    @Override
    public void write(DOMOutput out) throws IOException {
        super.write(out);
        out.openElement("locator");
        out.writeObject(this.locator);
        out.closeElement();
    }
}

